% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_psem.R
\name{plot.psem}
\alias{plot.psem}
\title{Plotting of Piecewise Structural Equation Models}
\usage{
\method{plot}{psem}(
  x,
  return = FALSE,
  node_attrs = data.frame(shape = "rectangle", color = "black", fillcolor = "white"),
  edge_attrs = data.frame(style = "solid", color = "black"),
  ns_dashed = T,
  alpha = 0.05,
  show = "std",
  digits = 3,
  add_edge_label_spaces = TRUE,
  ...
)
}
\arguments{
\item{x}{a [psem()] object}

\item{return}{whether to return the output from [DiagrammeR::create_graph()] for modification and later plotting}

\item{node_attrs}{List of node attributes to override defaults of rectangular nodes with black outline and white fill. See [here](http://visualizers.co/diagrammer/articles/node-edge-data-frames.html) and [here](http://visualizers.co/diagrammer/articles/graphviz-mermaid.html) for a more complete rundown of options.}

\item{edge_attrs}{List of edge attributes to override defaults of solid black arrows. See [here](http://visualizers.co/diagrammer/articles/node-edge-data-frames.html) and [here](http://visualizers.co/diagrammer/articles/graphviz-mermaid.html) for a more complete rundown of options.}

\item{ns_dashed}{If TRUE, paths that are not different from 0 will be dashed rather than solid, unless the whole is overridden in `edge_attrs`}

\item{alpha}{The alpha level for assessing whether a path is different from 0}

\item{show}{What types of path coefficients are shown? Default `"std"` is standardized coefficients. For undstandardized, use `"unstd"`}

\item{digits}{How many significant digits should be shown?}

\item{add_edge_label_spaces}{Should spaces by added on either side of edge labels? Default is `TRUE` as otherwise paths too often overlap edges.}

\item{...}{Other arguments to [DiagrammeR::render_graph()]}
}
\value{
Returns an object of class [DiagrammeR::dgr_graph]
}
\description{
plot.psem uses [DiagrammeR] to generate path diagrams 
of `piecewiseSEM`` fits within R.
}
\examples{
data(keeley)

mod <- psem(
  lm(rich ~ cover, data=keeley),
  lm(cover ~ firesev, data=keeley),
  lm(firesev ~ age, data=keeley),
  data = keeley
)

plot(mod)

### More customized plot

plot(mod, node_attrs = list(
  shape = "rectangle", color = "black",
  fillcolor = "orange", x = 3, y=1:4))
  
}
\author{
Jarrett Byrnes <jarrett.byrnes@umb.edu>
}
