% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allele_genotype.R
\name{extractASCTable}
\alias{extractASCTable}
\title{Extracts the allele cluster table from the archive file.}
\usage{
extractASCTable(archive_file = NULL)
}
\arguments{
\item{archive_file}{A path to the asc archive file. Default is null. (see details)}
}
\value{
Returns the allele cluster table.

The table columns:
\code{new_allele} - the ASC given allele name
\code{func_group} - the ASC cluster number
\code{imgt_allele} - the original IUIS/IMGT allele name
\code{thresh} - the allele threshold for ASC-based genotype inference
\code{amplicon_length} - is the original length of the reference set.
}
\description{
Extracts the allele cluster table from the archive file.
}
\details{
For downloading the latest archive file with the updated allele cluster table, use the function \code{recentAlleleClusters}.
}
\examples{

\donttest{
asc_archive <- recentAlleleClusters(doi="10.5281/zenodo.7429773", get_file = TRUE)

allele_cluster_table <- extractASCTable(archive_file = asc_archive)
}


}
