% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qpin_plot.R
\name{qpin_plot}
\alias{qpin_plot}
\title{PIN Visualization}
\usage{
qpin_plot(qpin_obj)
}
\arguments{
\item{qpin_obj}{List returned by \code{\link{qpin}}}
}
\description{
Visualization of quarterly estimates and probability of informed trading with ggplot2.
}
\examples{
# Loading one year of simulated daily buys and sells

data('BSfrequent2015')

# Quarterly estimates for model parameters and the probability of informed trading
# Rownames of 'BSfrequent2015' equal the business days in 2015.

qpin_list <- qpin(numbuys = BSfrequent2015[,"Buys"], numsells = BSfrequent2015[,"Sells"],
                  dates = as.Date(rownames(BSfrequent2015), format = "\%Y-\%m-\%d"))
                  
# Visualization of quarterly estimates
                   
qpin_plot(qpin_list)

}
\references{
Wickham, Hadley (2009) \cr
ggplot2: Elegant Graphics for Data Analysis \cr
\emph{Springer-Verlag New York} \cr
\doi{10.1007/978-0-387-98141-3}

Wickham, Hadley (2007) \cr
Reshaping Data with the reshape Package \cr
\emph{Journal of Statistical Software}, Volume 21, Issue 12, pp. 1 - 20 \cr
\doi{10.18637/jss.v021.i12}

Wickham, Hadley (2016) \cr
scales: Scale Functions for Visualization \cr
\emph{R package version 0.4.0}
}
\seealso{
\code{\link{qpin}}
}

