% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/board_azure.R
\name{board_azure}
\alias{board_azure}
\title{Use an Azure Blob Storage Container as a board}
\usage{
board_azure(container, n_processes = 10, versioned = TRUE, cache = NULL)
}
\arguments{
\item{container}{An azure storage container created by
\code{\link[AzureStor:blob_container]{AzureStor::blob_container()}} or similar.}

\item{n_processes}{Maximum number of processes used for parallel
uploads/downloads.}

\item{versioned}{Should this board be registered with support for versions?}

\item{cache}{Cache path. Every board requires a local cache to avoid
downloading files multiple times. The default stores in a standard
cache location for your operating system, but you can override if needed.}
}
\description{
Pin data to a container on Azure's blog storage using the AzureStor package.
}
\examples{
if (requireNamespace("AzureStor")) {
  # Public access board
  url <- "https://pins.blob.core.windows.net/public-data"
  container <- AzureStor::blob_container(url)
  board <- board_azure(container)
  board \%>\% pin_read("mtcars")
}

\dontrun{
# To create a board that you can write to, you'll need to supply one
# of `key`, `token`, or `sas` to AzureStor::blob_container()
container <- AzureStor::blob_container(url, key = "my-key")
board <- board_azure(container)
board \%>\% pin_write(iris)
}
}
