% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/board.R, R/board_azure.R, R/board_connect.R,
%   R/board_folder.R, R/board_gcs.R, R/board_kaggle.R, R/board_s3.R
\name{board_deparse}
\alias{board_deparse}
\alias{board_deparse.pins_board_azure}
\alias{board_deparse.pins_board_connect}
\alias{board_deparse.pins_board_folder}
\alias{board_deparse.pins_board_gcs}
\alias{board_deparse.pins_board_kaggle_competition}
\alias{board_deparse.pins_board_kaggle_dataset}
\alias{board_deparse.pins_board_s3}
\title{Deparse a board object}
\usage{
board_deparse(board, ...)

\method{board_deparse}{pins_board_azure}(board, ...)

\method{board_deparse}{pins_board_connect}(board, ...)

\method{board_deparse}{pins_board_folder}(board, ...)

\method{board_deparse}{pins_board_gcs}(board, ...)

\method{board_deparse}{pins_board_kaggle_competition}(board, ...)

\method{board_deparse}{pins_board_kaggle_dataset}(board, ...)

\method{board_deparse}{pins_board_s3}(board, ...)
}
\arguments{
\item{board}{A pin board, created by \code{\link[=board_folder]{board_folder()}}, \code{\link[=board_connect]{board_connect()}},
\code{\link[=board_url]{board_url()}} or another \code{board_} function.}

\item{...}{Additional arguments passed on to methods for a specific board.}
}
\value{
A call.
}
\description{
Returns the R code that would recreate the board when re-run on another
computer. Goal is to capture the location of the board, but not the
authorisation, since (a) that would leak credentials and (b) in
most deployment scenarios board auth will be read from env vars.
}
\examples{
\dontrun{
board <- board_connect()
# Generate code to access this board from elsewhere
board_deparse(board)
}
}
\keyword{internal}
