% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/board_gdrive.R
\name{board_gdrive}
\alias{board_gdrive}
\title{Use a Google Drive folder as a board}
\usage{
board_gdrive(path, versioned = TRUE, cache = NULL)
}
\arguments{
\item{path}{Path to existing directory on Google Drive to store pins. Can be
given as an actual path like \code{"path/to/folder"} (character), a file id or
URL marked with \code{\link[googledrive:drive_id]{googledrive::as_id()}}, or a \link[googledrive:dribble]{googledrive::dribble}.}

\item{versioned}{Should this board be registered with support for versions?}

\item{cache}{Cache path. Every board requires a local cache to avoid
downloading files multiple times. The default stores in a standard
cache location for your operating system, but you can override if needed.}
}
\description{
Pin data to a folder in Google Drive using the googledrive package.
}
\details{
\itemize{
\item The functions in pins do not create a new Google Drive folder. You can
create a new folder from R with \code{\link[googledrive:drive_mkdir]{googledrive::drive_mkdir()}}, and then set
the sharing for your folder with \code{\link[googledrive:drive_share]{googledrive::drive_share()}}.
\item If you have problems with authentication to Google Drive, learn more at
\code{\link[googledrive:drive_auth]{googledrive::drive_auth()}}.
\item \code{board_gdrive()} is powered by the googledrive package, which is a
suggested dependency of pins (not required for pins in general). If
you run into errors when deploying content to a server like
\url{https://www.shinyapps.io} or \href{https://posit.co/products/enterprise/connect/}{Connect},
add \code{requireNamespace("googledrive")} to your app or document for \href{https://docs.posit.co/connect/user/troubleshooting/#render-missing-r-package}{automatic dependency discovery}.
}
}
\examples{
\dontrun{
board <- board_gdrive("folder-for-my-pins")
board \%>\% pin_write(1:10, "great-integers", type = "json")
board \%>\% pin_read("great-integers")
}
}
