% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aliases.R
\name{pipe_remove_step}
\alias{pipe_remove_step}
\title{Remove certain step from the pipeline.}
\usage{
pipe_remove_step(pip, step, recursive = FALSE)
}
\arguments{
\item{pip}{\code{Pipeline} object}

\item{step}{\code{string} the name of the step to be removed}

\item{recursive}{\code{logical} if \code{TRUE} the step is removed together
with all its downstream dependencies.}
}
\value{
the \code{Pipeline} object invisibly
}
\description{
Can be used to remove any given step.
If other steps depend on the step to be removed, an error is
given and the removal is blocked, unless \code{recursive} was set to \code{TRUE}.
}
\examples{
p <- pipe_new("pipe", data = 1:2)
pipe_add(p, "add1", \(data = ~data, x = 1) x + data)
pipe_add(p, "add2", \(x = 1, y = ~add1) x + y)
pipe_add(p, "mult1", \(x = 1, y = ~add2) x * y)
p

pipe_remove_step(p, "mult1")
p

try(pipe_remove_step(p, "add1"))
pipe_remove_step(p, "add1", recursive = TRUE)
p
}
