% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{check_data_frame_throw_error}
\alias{check_data_frame_throw_error}
\title{Validate ml_pipeline_builder transform method returns data.frame}
\usage{
check_data_frame_throw_error(func_return_object, func_name)
}
\arguments{
\item{func_return_object}{The object returned from a \code{ml_pipeline_builder} method.}

\item{func_name}{The name of the function that returned the object.}
}
\description{
Helper function that checks if the object returned from a \code{ml_pipeline_builder} method is
data.frame (if it isn't NULL), and if it isn't, throws an error that is customised with the
returning name.
}
\examples{
\dontrun{
transform_method <- function(df) df
data <- data.frame(y = c(1, 2), x = c(0.1, 0.2))
data_transformed <- transform_method(data)
check_data_frame_throw_error(data_transformed, "transform_method")
# NULL
}
}

