% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_twin_tree.R
\name{create_twin_tree}
\alias{create_twin_tree}
\title{Create a twin tree}
\usage{
create_twin_tree(phylogeny, twinning_params = create_twinning_params())
}
\arguments{
\item{phylogeny}{a phylogeny of class \link[ape]{phylo}}

\item{twinning_params}{can be \code{NA} if no twinning is desired,
or can be the twinning parameters,
as can be created by \link{create_twinning_params}}
}
\value{
a phylogeny of type \link[ape]{phylo}
}
\description{
It sets the seed with value \code{twinning_params$rng_seed_twin_tree},
then generates a tree by
calling \code{twinning_paramssim_twin_tree_fun} on the
given tree.
}
\examples{
phylogeny <- ape::read.tree(text = "((A:1, B:1):1, C:2);")
twin_phylogeny <- create_twin_tree(phylogeny)
}
\author{
Richèl J.C. Bilderbeek, Giovanni Laudanno
}
