% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complete_treelog_filename.R
\name{complete_treelog_filename}
\alias{complete_treelog_filename}
\title{Complete a treelog's filename}
\usage{
complete_treelog_filename(treelog_filename, fasta_filename)
}
\arguments{
\item{treelog_filename}{name of the MCMC's treelog file,
which is \code{$(tree).trees} by default.
Use \link{complete_treelog_filename} to obtain the complete path to
the MCMC's treelog file.}

\item{fasta_filename}{name of a FASTA file.
Use \link{get_alignment_id} to get the ID of the alignment}
}
\value{
the filename for the treelog
}
\description{
Complete a treelog's filename
}
\examples{
# Check cleanup by other functions
beastier::check_empty_beaustier_folders()

fasta_filename <- "/home/alignment_folder/my.fasta"

# Will become '/home/alignment_folder/my.trees'
complete_treelog_filename(
  treelog_filename = "$(tree).trees",
  fasta_filename = fasta_filename
)

}
\author{
Richèl J.C. Bilderbeek
}
