% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot.R
\name{pivot}
\alias{pivot}
\title{Pivot easily by specifying rows, columns, values and split.}
\usage{
pivot(df, row, col, value, split = NULL, sep = "_")
}
\arguments{
\item{df}{A dataframe.}

\item{row, value}{A string or string vector.}

\item{col}{A string or string vector.}

\item{split}{A string or string vector.}

\item{sep}{A string for separator.}
}
\value{
A dataframe.
}
\description{
Pivot easily by specifying rows, columns, values and split.
}
\examples{
library(tidyr)
library(dplyr)
library(purrr)
library(ggplot2)
starwars \%>\%
  pivot(row = "homeworld", col = "species", value = "name", split = "sex")
msleep \%>\%
  pivot(row = "vore", col = "conservation", value = "name") \%>\%
  na2empty() \%>\%
  print(n = nrow(.))
as_tibble(Titanic) \%>\%
  pivot(row = "Age", col = c("Sex", "Survived"), value = "n", split = "Class")
diamonds \%>\%
  pivot(row = "cut", col = "color", value = "price", split = "clarity")

}
