% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PivotBatchCalculator.R
\docType{class}
\name{PivotBatchCalculator}
\alias{PivotBatchCalculator}
\title{A class that calculates the values for multiple cells.}
\format{\code{\link{R6Class}} object.}
\usage{
PivotBatchCalculator
}
\value{
Object of \code{\link{R6Class}} with properties and methods that help
  to perform calculations in batch.
}
\description{
The PivotBatchCalculator class calculates the values for multiple cells in
the pivot table in one evaluation step.
}
\section{Fields}{

\describe{
\item{\code{parentPivot}}{Owning pivot table.}

\item{\code{batchCount}}{The number of batches generated for the pivot table.}

\item{\code{calculationSummary}}{A summary of the batch compatibility for each
calculation.}

\item{\code{batchSummary}}{A summary of the batches in the pivot table.}
}}

\section{Methods}{

\describe{
  \item{Documentation}{For more complete explanations and examples please see
  the extensive vignettes supplied with this package.}
  \item{\code{new(...)}}{Create a new batch calculator.}

  \item{\code{reset()}}{Clears any batches that currently exist in the batch
  calculator.}
  \item{\code{isFiltersBatchCompatible(filters=NULL)}}{Determines whether a
  set of filters are compatible with batch calculations.}
  \item{\code{generateBatchesForNamedCalculationEvaluation1(dataName=NULL,
  calculationName=NULL, calculationGroupName=NULL,
  workingFilters=NULL)}}{Generates one or more batches for a named
  calculation and single working filters object.}
  \item{\code{generateBatchesForNamedCalculationEvaluation2(calculationName=NULL,
  calculationGroupName=NULL, workingData=NULL)}}{Generates one or more
  batches for a named calculation and set of working working data
  associated with a cell.}
  \item{\code{generateBatchesForCellEvaluation()}}{Generates one or batches
  for a pivot table cell.}
  \item{\code{evaluateBatches()}}{Evaluates batch calculations.}
  \item{\code{getSummaryValueFromBatch(batchName=NULL, calculationName=NULL,
  calculationGroupName=NULL, workingFilters=NULL)}}{Retrieve a value from a
  the results of a batch that has been evaluated.}
}
}

\examples{
# This class should only be created by the pivot table.
# It is not intended to be created outside of the pivot table.
}
\keyword{datasets}
