% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sprinkle_gradient.R
\name{sprinkle_gradient}
\alias{sprinkle_gradient}
\alias{sprinkle_gradient.dust}
\alias{sprinkle_gradient.dust_list}
\title{Change Color Features by Binning Numeric Values}
\usage{
sprinkle_gradient(x, rows = NULL, cols = NULL, gradient = "bg",
  gradient_colors = getOption("pixie_gradient_pal", NULL),
  gradient_cut = NULL, gradient_n = 10, gradient_na = "grey",
  part = c("body", "head", "foot", "interfoot"), fixed = FALSE,
  recycle = c("none", "rows", "cols", "columns"), ...)

\method{sprinkle_gradient}{dust}(x, rows = NULL, cols = NULL,
  gradient = "bg", gradient_colors = getOption("pixie_gradient_pal",
  c("#132B43", "#56B1F7")), gradient_cut = NULL, gradient_n = 10,
  gradient_na = "grey", part = c("body", "head", "foot", "interfoot"),
  fixed = FALSE, recycle = c("none", "rows", "cols", "columns"), ...)

\method{sprinkle_gradient}{dust_list}(x, rows = NULL, cols = NULL,
  gradient = "bg", gradient_colors = getOption("pixie_gradient_pal",
  c("#132B43", "#56B1F7")), gradient_cut = NULL, gradient_n = 10,
  gradient_na = "grey", part = c("body", "head", "foot", "interfoot"),
  fixed = FALSE, recycle = c("none", "rows", "cols", "columns"), ...)
}
\arguments{
\item{x}{An object of class \code{dust}}

\item{rows}{Either a numeric vector of rows in the tabular object to be 
modified or an object of class \code{call}.  When a \code{call}, 
generated by \code{quote(expression)}, the expression resolves to 
a logical vector the same length as the number of rows in the table.
Sprinkles are applied to where the expression resolves to \code{TRUE}.}

\item{cols}{Either a numeric vector of columns in the tabular object to
be modified, or a character vector of column names. A mixture of 
character and numeric indices is permissible.}

\item{gradient}{\code{character}. A subset of \code{c("bg", "font", 
"font_color", "border", "left_border", "top_border", "right_border",
"bottom_border")}.}

\item{gradient_colors}{\code{character(2)}. Gives the colors between 
which to shared gradients.}

\item{gradient_cut}{\code{numeric}. Determines the breaks points for the 
gradient shading. When \code{NULL} equally spaced quantiles are used, 
the number of which are determined by \code{gradient_n}.}

\item{gradient_n}{\code{numeric(1)}. Determines the number of shades to use 
between the colors in \code{gradient_colors}}

\item{gradient_na}{\code{character(1)} A valid color that sets the color of 
\code{NA} values when shading a numeric range.}

\item{part}{A character string denoting which part of the table to modify.}

\item{fixed}{\code{logical(1)} indicating if the values in \code{rows} 
and \code{cols} should be read as fixed coordinate pairs.  By default, 
sprinkles are applied at the intersection of \code{rows} and \code{cols}, 
meaning that the arguments do not have to share the same length.  
When \code{fixed = TRUE}, they must share the same length.}

\item{recycle}{A \code{character} one that determines how sprinkles are 
managed when the sprinkle input doesn't match the length of the region
to be sprinkled.  By default, recycling is turned off.  Recycling 
may be performed across rows first (left to right, top to bottom), 
or down columns first (top to bottom, left to right).}

\item{...}{Additional arguments to pass to other methods. Currently ignored.}
}
\description{
Numeric values within a range of cells are binned and colors
  assigned to show gradual increases in the numeric value.
}
\details{
This sprinkle is only recognized by HTML and LaTeX.  All of the 
  \code{height_units} values are recognized by HTML.  For LaTeX, \code{"px"}
  is converted to \code{"pt"}. 
  
\code{"font"} and \code{"font_color"} both change the font color.

\code{"border"} is a shortcut to specify all borders.
}
\section{Functional Requirements}{

\enumerate{
 \item Correctly reassigns the appropriate elements of the \code{bg},
   \code{font_color}, \code{left_border}, \code{top_border},
   \code{right_border}, or \code{bottom_border} column in the table part.
 \item Casts an error if \code{x} is not a \code{dust} object.
 \item Casts an error if \code{gradient} is not a subset of 
   \code{c("bg", "font", "font_color", "border", "left_border",
           "right_border", "top_border", "bottom_border")}
 \item Casts an error if \code{gradient_colors} is not a \code{character(2)}
   value.
 \item Casts an error if any value of \code{gradient_colors} is not a
   recognized color value.
 \item Casts an error if \code{gradient_cut} is not \code{numeric}.
 \item Casts an error if \code{gradient_n} is not \code{numeric(1)}.
 \item Casts an error if \code{gradient_na} is not \code{character(1)}.
 \item Casts an error if \code{gradient_na} is not a valid color.
 \item Casts an error if \code{part} is not one of \code{"body"}, 
   \code{"head"}, \code{"foot"}, or \code{"interfoot"}
 \item Casts an error if \code{fixed} is not a \code{logical(1)}
 \item Casts an error if \code{recycle} is not one of \code{"none"},
   \code{"rows"}, or \code{"cols"}
}

The functional behavior of the \code{fixed} and \code{recycle} arguments 
is not tested for this function. It is tested and validated in the
tests for \code{\link{index_to_sprinkle}}.
}
\seealso{
\code{\link{sprinkle}}, 
  \code{\link{index_to_sprinkle}}
}

