% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.r
\name{plotPackageGraph}
\alias{plotPackageGraph}
\title{Plot a graph or diagram of a package}
\usage{
plotPackageGraph(graph, fun.list, use.subgraphs = FALSE, use.colors = FALSE)
}
\arguments{
\item{graph}{A list generated by \code{\link[pkgGraphR]{buildPackageGraph}}
containing edges and nodes of the graph.}

\item{fun.list}{An optional list generated by \code{\link[pkgGraphR]{collectFunNames}}
containing each files function assignments. Used only if `use.subgraphs` or
`use.colors` are true}

\item{use.subgraphs}{Logical indicating whether the graph should be partitioned
into subgraphs by the file in which the function assignment was made.
DEFAULT: FALSE}

\item{use.colors}{Logical indicating whether the nodes of the graph should be
colored by the file in which the function assignment was made.
N.B. No legend is plotted for the colors.
DEFAULT: FALSE}
}
\value{
A grviz plot.
}
\description{
From a list of nodes and edges, plots a diagram or graph
}
\examples{
pkgGraph <- system.file("extdata", package = "pkgGraphR") |>
    buildPackageGraph()
plotPackageGraph(graph = pkgGraph)

pkgFuns <- system.file("extdata", package = "pkgGraphR") |>
    collectFunNames()

plotPackageGraph(graph = pkgGraph, fun.list = pkgFuns, use.subgraphs = TRUE)
plotPackageGraph(graph = pkgGraph, fun.list = pkgFuns, use.colors = TRUE)
plotPackageGraph(graph = pkgGraph, fun.list = pkgFuns, use.colors = TRUE, use.subgraphs = TRUE)

}
\seealso{
\code{\link[pkgGraphR]{collectFunNames}}, \code{\link[pkgGraphR]{buildPackageGraph}}
}
