% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rfast99.R
\name{rfast99}
\alias{rfast99}
\title{Extended Fourier Amplitude Sensitivity Test with Random Phase Shift}
\source{
This function is based on \code{fast99} function in \pkg{sensitivity} package.
}
\usage{
rfast99(params, n, M = 4, omega = NULL, q = NULL, q.arg = NULL,
  replicate = 1, conf = 0.95)
}
\arguments{
\item{params}{an integer for the giving number of parameters, or a vector of character strings giving their names.}

\item{n}{an integer for the sampling number.}

\item{M}{an integer specifying the interference parameter. The default is 4.}

\item{omega}{a vector giving the set of frequencies.}

\item{q}{a vector of quantile functions names corresponding to wanted parameters distributions.}

\item{q.arg}{a list of quantile functions parameters.}

\item{replicate}{an integer to define the number of replication. The default is set to 1 turn off the replication.}

\item{conf}{the confidence level for replication confidence intervals. The default is 0.95.}
}
\value{
The returned parameter value will be stored in an array with
c(model evaluation, replication, parameters).
}
\description{
\code{rfast99} is used to create the sequances for each parameter.
It is based on the \code{fast99} function in \pkg{sensitivity} package.
}
\examples{
# Generate the parameter matrix with 20 replications
q <- "qunif"
q.arg <- list(min = 0, max = 1)

set.seed(1234)
x <- rfast99(params = 3, n = 100, replicate = 20, q = q, q.arg = q.arg)
dim(x$a) # the array of c(model evaluation, replication, parameters).

\dontrun{
save(x, file = "input_parameters.rda")
}

}
\references{
A. Saltelli, S. Tarantola and K. Chan, 1999, A quantitative, model independent method for
global sensitivity analysis of model output,
\emph{Technometrics}, 41, 39-56.

R. I. Cukier, H. B. Levine and K. E. Schuler, 1978,
Nonlinear sensitivity analysis of multiparameter model systems.
\emph{J. Comput. Phys.}, 26, 1–42.
}
