\name{read.gantt}

\alias{read.gantt}

\title{Read a gantt data file}

\description{Read a data file containing gantt information.}

\usage{read.gantt(file, debug=FALSE)}

\arguments{
  \item{file}{a connection or a character string giving the name of the
    file to load.}
  \item{debug}{boolean, set to \code{TRUE} to print debugging
    information.}
}

\details{Reads a \code{gantt} dataset.

  The data format is strict, and deviations from it may lead to
  error messages that are difficult to understand.

  The first line is a header, and must contain the words \code{Key},
  \code{Description}, \code{Start}, \code{End}, \code{Done}, and
  \code{NeededBy}, written exactly in this way, with commas separating
  the words.  (Blanks are ignored in this line.)

  Additional lines indicate the details of each of several sub-projects,
  in comma-separated items, as follows:

  \itemize{
    \item A key for the task.  These must be distinct, and are typically
    just the numbers 1, 2, 3, etc.

    \item A description of the task.  (This may not contain commas!)

    \item The start time for the task, in ISO 8601 format
    (\code{YYYY-MM-DD} or \code{YYYY-MM-DD hh:mm:ss}).

    \item The end time for the task, in the same format as the starting time.

    \item A number indicating the percentage of this task that has been
    completed to date.

    \item A space-separated optional list of numbers that indicate the
    keys of other tasks that depend on this one.  This list is ignored
    in the present version of \code{read.gantt}.
  }

Executing the code
\preformatted{
  library(plan)
  data(gantt)
  print(summary(gantt))
}
will create the following sample file, which may be read with
\code{\link{read.gantt}}:
\preformatted{
Key, Description,            Start,      End,        Done, NeededBy
  1, Assemble equipment,     2008-01-01, 2008-03-28,   90
  2, Test methods,           2008-02-28, 2008-03-28,   30
  3, Field sampling,         2008-04-01, 2008-08-14,    0
  4, Analyse field data,     2008-06-30, 2008-11-14,    0
  5, Write methods chapter,  2008-08-14, 2008-11-14,    0
  6, Write results chapter,  2008-10-14, 2009-01-15,    0
  7, Write other chapters,   2008-12-10, 2009-02-28,    0
  8, Committee reads thesis, 2009-02-28, 2009-03-14,    0
  9, Revise thesis,          2009-03-15, 2009-03-30,    0
 10, Thesis on display,      2009-04-01, 2009-04-15,    0
 11, Defend thesis,          2009-04-16, 2009-04-17,    0
 12, Finalize thesis,        2009-04-18, 2009-05-07,    0
}
}

\value{An object of type \code{"gantt"}, which is a data frame containing
\code{"description"} (a character description of the task)
\code{"start"} (the task's start time),
\code{"end"} (the task's end time),
\code{"progress"} (a number giving the percent progress on this item, or
\code{NA} if none given), and
\code{"needed.by"} (a number giving the indices of other tasks that rely
on this task, or \code{NA} if none given).
}

\seealso{\code{\link{summary.gantt}} and \code{\link{plot.gantt}}}

\examples{
\dontrun{
library(plan)
gantt <- read.gantt("demo/gantt.dat")
summary(gantt)
plot(gantt)
}
}

\author{Dan Kelley}

\keyword{misc}
