% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregateByGenet.R
\name{aggregateByGenet}
\alias{aggregateByGenet}
\title{aggregateByGenet}
\usage{
aggregateByGenet(
  dat,
  site = "Site",
  quad = "Quad",
  species = "Species",
  year = "Year",
  trackID = "trackID",
  ...
)
}
\arguments{
\item{dat}{An sf data.frame. Typically this is a data.frame that has been
returned from the \code{\link[=trackSpp]{trackSpp()}} function, although 'dat' can be any sf
data.frame of plant demographic data in which each genet is given unique
identifying value (what we call here a 'trackID'). If 'dat' already only has
one row for each unique trackID in each unique year (i.e. there are no
vegetative individuals--no ramets), then the output of \code{\link[=aggregateByGenet]{aggregateByGenet()}}
will have the same number of rows as 'dat'. If 'dat' has
multiple rows (each of which is a ramet) for the same trackID in the same
year, then the output of \code{\link[=aggregateByGenet]{aggregateByGenet()}} will have fewer rows than the
input 'dat' data.frame. 'dat' MUST have columns called 'basalArea_genet',
'age', 'recruit', 'survives_tplus1', 'nearEdge', and 'size_tplus1', although
they can be populated with NAs. The \code{\link[=trackSpp]{trackSpp()}} function adds these columns,
so if you have made no changes to the data.frame that was returned from
\code{\link[=trackSpp]{trackSpp()}}, then your data.frame should have these columns already.}

\item{site}{A character string giving the name of the column in 'dat' that
contains the values for site. The default is "Site".}

\item{quad}{A character string giving the name of the column in 'dat' that
contains the values for quadrat. The default is "Quad".}

\item{species}{A character string giving the name of the column in 'dat' that
contains the values for species. The default is "Species".}

\item{year}{A character string giving the name of the column in 'dat' that
contains the values for year. The default is "Year".}

\item{trackID}{A character string giving the name of the column in 'dat' that
contains the values for the unique identifier, or trackID. The default
is "trackID".}

\item{...}{Other arguments passed on to methods. Not currently used.}
}
\value{
An sf data.frame that has been aggregated by genet so that each row
represents one unique genetic individual in one year. This data.frame has
columns containing data for site, quadrat, species, year, and trackID, as
well as columns called 'basalArea_genet', 'age', 'recruit',
'survives_tplus1', 'nearEdge', and 'size_tplus1'. This data.frame will most
likely be shorter than the input 'dat', because a genet that was previously
broken into multiple rows representing each ramet in each year will now have
only one row in each year.
}
\description{
This function aggregates a data.frame by unique trackIDs so that
each row represents a genet (unique genetic individual) in a given year.
}
\details{
This function is a \pkg{plantTracker}-specific, user-friendly
wrapper for the 'aggregate' function. This function was designed for use
within the \code{\link{trackSpp}} function, but can be also called
independently by the user. The function is designed to take a data.frame of
the same format that is returned by \code{\link[=trackSpp]{trackSpp()}}, but it can be used to
aggregate any dataset by genet (or some other unique identifier), as long as
there is a column that identifies genet (or unique identifier) identity for
each observation.
}
\examples{
dat <- grasslandData[grasslandData$Site == c("AZ") &
 grasslandData$Species \%in\% c("Bouteloua rothrockii", "Calliandra eriophylla" ),]
names(dat)[1] <- "speciesName"
inv <- grasslandInventory[unique(dat$Quad)]
outDat <- trackSpp(dat = dat,
 inv = inv,
 dorm = 1,
 buff = .05,
 buffGenet = 0.005,
 clonal = data.frame("Species" = unique(dat$speciesName),
 "clonal" = c(TRUE,FALSE)),
 species = "speciesName",
 aggByGenet = FALSE
 )

aggregateByGenet(dat = outDat,
species = 'speciesName')
}
\seealso{
This function is called inside the \code{\link[=trackSpp]{trackSpp()}} function.
}
