## ------------------------------------------------------------------------
library(plantecophys)

## ----echo=FALSE----------------------------------------------------------
acidata1$Rd <- NULL

## ---- echo=FALSE---------------------------------------------------------
knitr::kable(acidata1[,c("Ci","Photo","Tleaf","PARi")])

## ----eval=FALSE----------------------------------------------------------
#  mydata <- read.csv("myfile.csv")

## ------------------------------------------------------------------------
fit <- fitaci(acidata1)

## ------------------------------------------------------------------------
fit

## ------------------------------------------------------------------------
coef(fit)

## ---- fig.width=7, fig.height=5, echo=-1---------------------------------
par(mar=c(5,5,2,2), cex.lab=1.1)
plot(fit)

## ------------------------------------------------------------------------
fit2 <- fitaci(acidata1, Tcorrect=FALSE)

## ---- echo=-1------------------------------------------------------------
acidata2 <- acidata1
acidata2$Rd <- 2
fit3 <- fitaci(acidata2, useRd=TRUE)
coef(fit3)

## ---- eval=FALSE---------------------------------------------------------
#  fit4 <- fitaci(acidata1, varnames=c(ALEAF="Photo", Tleaf="Tair", Ci="Ci", PPFD="PARi"))

## ------------------------------------------------------------------------
fit5 <- fitaci(acidata1, Tleaf=30, PPFD=2000)

## ------------------------------------------------------------------------
fit6 <- fitaci(acidata1, gmeso=0.2)

## ----fig.width=7, fig.height=5, echo=-1----------------------------------
par(mar=c(5,5,2,2), cex.lab=1.1)
fit7 <- fitaci(acidata1, fitTPU=TRUE)
plot(fit7)

## ------------------------------------------------------------------------
coef(fit7)

