% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_gpcm.R
\name{fit.gpcm}
\alias{fit.gpcm}
\title{Fits LMA model where category scale values equal a_im * x_j}
\usage{
fit.gpcm(
  Master,
  Phi.mat,
  PersonByItem,
  TraitByTrait,
  item.by.trait,
  tol,
  npersons,
  nitems,
  ncat,
  nless,
  ntraits,
  Maxnphi,
  pq.mat,
  starting.sv,
  ItemNames,
  LambdaName,
  LambdaNames,
  PhiNames
)
}
\arguments{
\item{Master}{Master data set in long format}

\item{Phi.mat}{Matrix of starting values of association parameters}

\item{PersonByItem}{Person by item matrix of responses (same as inData)}

\item{TraitByTrait}{Trait by trait adjacency matrix (same as inTraitAdj)}

\item{item.by.trait}{Item by trait vector indicating trait item load on (same as inItemTraitAdj)}

\item{tol}{Criterion used to determine convergence}

\item{npersons}{Number of persons}

\item{nitems}{Number of items}

\item{ncat}{Number of categories per item}

\item{nless}{Number of categories minus 1 (i.e., unique lambdas)}

\item{ntraits}{Number of latent traits}

\item{Maxnphi}{Number of phi parameters to be estimated}

\item{pq.mat}{Used to compute rest-scores and totals}

\item{starting.sv}{Fixed category scores}

\item{ItemNames}{Names of items needed label output}

\item{LambdaName}{Names of lambdas needed for formula of the item regressions}

\item{LambdaNames}{Names of lambdas needed for formula of the stacked regression}

\item{PhiNames}{Name of phi parameters (Null for uni-dimensional models)}
}
\value{
item.log		  History over iterations of the algorithm for items' log likelihood,
                        lambda, and a parameter

phi.log			  History over iterations of the algorithm for log likelihood, lambdas
                         nd phi parameters

criterion		  Current value of the convergence statistic which is the maximum of items'
                         absolute differences between the current and previous value of the log
                         likelihood

estimates   	An item by parameter matrix of estimated item parameter where the
                         first column are items' log likelihood

Phi.mat	   	  Estimated matrix of association parameters

fitem		      Formula for item data

fstack	      Formula for stacked data

item.mnlogit 	Summary from final run of mnlogit for item regressions for each item

phi.mnlogit	  Summary from final run mnlogit for stacked regression

mlpl.item     Value of maximum of log ple function from fitting items (i.e., sum of logLike)

mlpl.phi	    Value of maximum of log ple function from stacked regression to get phi estimates

AIC           Akaike information criterion for pseudo-likelihood (smaller is better)

BIC           Bayesian information criterion for pseudo-likelihood (smaller is better)
}
\description{
Function estimates the parameters of LMA models with fixed category scores
multiplied by an item weight parameter. This function can be used to estimate
the LMA model corresponding to is a generalized partial credit model for
multi-category items and the 2 parameter logistic model for dichotomous
items. The function sets up log objects and model formula.  In the case of
unidimensional models, the function iterates over item regressions; whereas,
for multidimensional models, the function iterates between the item and phi
regressions.  This function is called from 'ple.lma', but can be run outside
of 'ple.lma'.
}
\examples{
 data(dass)
 inData <- dass[1:250,c("d1", "d2", "a1","a2","s1","s2")]
 #--- unidimensional
 inTraitAdj  <- matrix(1, nrow=1, ncol=1)
 inItemTraitAdj <- matrix(1, nrow=6, ncol=1)

# Need to set up data
s <- set.up(inData, model.type='gpcm', inTraitAdj, inItemTraitAdj, tol=1e-03)

g <- fit.gpcm(s$Master, s$Phi.mat, s$PersonByItem, s$TraitByTrait,
              s$item.by.trait, s$tol, s$npersons, s$nitems, s$ncat,
              s$nless, s$ntraits, s$Maxnphi, s$pq.mat, s$starting.sv,
              s$ItemNames, s$LambdaName, s$LambdaNames, s$PhiNames)

}
