\name{init.GP}
\alias{init.GP}
\alias{init.CGP}
\alias{init.ConstGP}

\title{
  Initialize particles for GPs
}
\description{
  Functions for initializing particles for Gaussian process (GP)
  regression, classification, or combined unknown constraint
  models
}
\usage{
init.GP(prior, d = NULL, g = NULL, Y = NULL)
init.CGP(prior, d = NULL, g = NULL)
init.ConstGP(prior)
}

\arguments{
  \item{prior}{
    prior parameters passed from \code{\link{PL}} generated by one of
    the prior functions, e.g., \code{\link{prior.GP}}
  }
  \item{d}{
    initial range (or length-scale) parameter(s) for the GP correlation
    function(s)
  }
  \item{g}{
    initial nugget parameter for the GP correlation
  }
  \item{Y}{
    data used to update GP sufficient information in the case of
  \code{init.GP}; if \code{NULL} then \code{pall$Y} is used
  }
}

\value{
  Returns a particle for internal use in the \code{\link{PL}} method
}

\references{
 Gramacy, R. and Polson, N. (2011).
  \dQuote{Particle learning of Gaussian process models for
    sequential design and optimization.}
  Journal of Computational and Graphical Statistics, 20(1), 
  pp. 102-118; arXiv:0909.5262

  Gramacy, R. and Lee, H. (2010).
  \dQuote{Optimization under unknown constraints}.
  \emph{Bayesian Statistics 9}, J. M. Bernardo, M. J. Bayarri,
  J. O. Berger, A. P. Dawid, D. Heckerman, A. F. M. Smith and M. West
  (Eds.); Oxford University Press

  \url{http://faculty.chicagobooth.edu/robert.gramacy/plgp.html}
}

\author{
Robert B. Gramacy, \email{rbgramacy@chicagobooth.edu}
}

\seealso{
\code{\link{PL}}, \code{\link{draw.GP}}
}
\examples{
## See the demos via demo(package="plgp") and the examples
## section of ?plgp
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ models }
\keyword{ regression }
\keyword{ classif }
\keyword{ methods }
