% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_imagem.R
\name{image_index}
\alias{image_index}
\alias{plot.image_index}
\title{Image indexes}
\usage{
image_index(
  image,
  index = NULL,
  my_index = NULL,
  resize = TRUE,
  re = NULL,
  nir = NULL,
  show_image = TRUE,
  nrow = NULL,
  ncol = NULL,
  parallel = FALSE,
  workers = NULL,
  verbose = TRUE
)

\method{plot}{image_index}(x, facet = TRUE, ...)
}
\arguments{
\item{image}{An image object.}

\item{index}{A character value (or a vector of characters) specifying the
target mode for conversion to binary image. One of the following:  \code{"R"},
\code{"G"}, \code{"B"} \code{"GR"}, \code{"NR"}, \code{"NG"}, \code{"NB"}, \code{"BI"}, \code{"BIM"}, \code{"SCI"},
\code{"GLI"}, \code{"HI"}, \code{"NGRDI"}, \code{"SI"}, \code{"VARI"}, \code{"HUE"}, \code{"HUE2"}, \code{"BGI"},
\code{"BGI"}. Defaults to \code{NULL} ((normalized) Red, Green and Blue).  One can
also use "RGB" for RGB only, "NRGB" for normalized RGB, or "all" for all
indexes.}

\item{my_index}{User can calculate a different index using the bands names,
e.g. \code{my_index = "R+B/G"}.}

\item{resize}{Resize the image before processing? Defaults to \code{TRUE}. Resizes
the image to 30\% of the original size to speed up image processing.}

\item{re}{Respective position of the red-edge band at the original image
file.}

\item{nir}{Respective position of the near-infrared band at the original
image file.}

\item{show_image}{Show image after processing?}

\item{nrow, ncol}{The number of rows or columns in the plot grid. Defaults to
\code{NULL}, i.e., a square grid is produced.}

\item{parallel}{Processes the images asynchronously (in parallel) in separate
R sessions running in the background on the same machine. It may speed up
the processing time when \code{image} is a list. The number of sections is set
up to 90\% of available cores.}

\item{workers}{A positive numeric scalar or a function specifying the maximum
number of parallel processes that can be active at the same time.}

\item{verbose}{If \code{TRUE} (default) a summary is shown in the console.}

\item{x}{An object of class \code{image_index}.}

\item{facet}{Shows RGB values as a facet plot? Defaults to \code{TRUE}.}

\item{...}{Currently not used}
}
\value{
A list containing Grayscale images. The length will depend on the
number of indexes used.

A \code{ggplot} object containing the distribution of the pixels for each
index.
}
\description{
Builds image indexes using Red, Green, Blue, Red-Edge, and NIR bands.

Produces an histogram of an \code{image_index} object
}
\details{
The following indexes are available in pliman.\tabular{lll}{
   Index \tab Equation \tab Band \cr
   R \tab R \tab C \cr
   G \tab G \tab C \cr
   B \tab B \tab C \cr
   NR \tab R/(R+G+B) \tab C \cr
   NG \tab G/(R+G+B) \tab C \cr
   NB \tab B/(R+G+B) \tab C \cr
   BI \tab sqrt((R^2+G^2+B^2)/3) \tab C \cr
   BIM \tab sqrt((R\emph{2+G}2+B*2)/3) \tab C \cr
   SCI \tab (R-G)/(R+G) \tab C \cr
   GLI \tab (2\emph{G-R-B)/(2}G+R+B) \tab C \cr
   HI \tab (2*R-G-B)/(G-B) \tab C \cr
   NGRDI \tab (G-R)/(G+R) \tab C \cr
   SI \tab (R-B)/(R+B) \tab C \cr
   VARI \tab (G-R)/(G+R-B) \tab C \cr
   HUE \tab atan(2*(B-G-R)/30.5*(G-R)) \tab C \cr
   HUE2 \tab atan(2*(R-G-R)/30.5*(G-B)) \tab C \cr
   BGI \tab B/G \tab C \cr
}
}
\examples{
library(pliman)
img <- image_import(image_pliman("soybean_touch.jpg"))
image_index(img, c("R, NR"), nrow = 1)
library(pliman)
img <- image_import(image_pliman("sev_leaf.jpg"))
img2 <- image_resize(img, 50)
ind <- image_index(img2)
plot(ind)
}
\references{
Nobuyuki Otsu, "A threshold selection method from gray-level
histograms". IEEE Trans. Sys., Man., Cyber. 9 (1): 62-66. 1979.
\doi{10.1109/TSMC.1979.4310076}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}

Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
