% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_imagem.R
\name{image_index}
\alias{image_index}
\alias{plot.image_index}
\title{Image indexes}
\usage{
image_index(
  image,
  index = NULL,
  my_index = NULL,
  resize = FALSE,
  re = NULL,
  nir = NULL,
  show_image = TRUE,
  nrow = NULL,
  ncol = NULL,
  parallel = FALSE,
  workers = NULL,
  verbose = TRUE
)

\method{plot}{image_index}(x, type = "raster", nrow = NULL, ncol = NULL, ...)
}
\arguments{
\item{image}{An image object.}

\item{index}{A character value (or a vector of characters) specifying the
target mode for conversion to binary image. Use \code{\link[=pliman_indexes]{pliman_indexes()}} or the
\code{details} section to see the available indexes.  Defaults to \code{NULL}
((normalized) Red, Green and Blue).  One can also use "RGB" for RGB only,
"NRGB" for normalized RGB, or "all" for all indexes.}

\item{my_index}{User can calculate a different index using the bands names,
e.g. \code{my_index = "R+B/G"}.}

\item{resize}{Resize the image before processing? Defaults to \code{30}, which
resizes the image to 30\% of the original size to speed up image processing.
Set \code{resize = FALSE} to keep the original size of the image.}

\item{re}{Respective position of the red-edge band at the original image
file.}

\item{nir}{Respective position of the near-infrared band at the original
image file.}

\item{show_image}{Show image after processing?}

\item{nrow, ncol}{The number of rows or columns in the plot grid. Defaults to
\code{NULL}, i.e., a square grid is produced.}

\item{parallel}{Processes the images asynchronously (in parallel) in separate
R sessions running in the background on the same machine. It may speed up
the processing time when \code{image} is a list. The number of sections is set
up to 70\% of available cores.}

\item{workers}{A positive numeric scalar or a function specifying the maximum
number of parallel processes that can be active at the same time.}

\item{verbose}{If \code{TRUE} (default) a summary is shown in the console.}

\item{x}{An object of class \code{image_index}.}

\item{type}{The type of plot. Use \code{type = "raster"} (default) to produce a
raster plot showing the intensity of the pixels for each image index or
\code{type = "density"} to produce a density plot with the pixels' intensity.}

\item{...}{Currently not used}
}
\value{
A list containing Grayscale images. The length will depend on the
number of indexes used.

A \code{trellis} object containing the distribution of the pixels for each
index.
}
\description{
\code{image_index()} Builds image indexes using Red, Green, Blue, Red-Edge, and NIR bands.

\code{plot.image_index()} produces a raster (\code{type = "raster"}, default) or a
density (\code{type = "density"}) plot of the index values computed with
\code{image_index()}.
}
\details{
The following indexes are available in pliman.
\itemize{
\item \code{R} red
\item \code{G} green
\item \code{B} blue
\item \code{NR} normalized red \code{R/(R+G+B)}.
\item \code{NG} normalized green \code{G/(R+G+B)}
\item \code{NB} normalized blue \code{B/(R+G+B)}
\item \code{GB} green blue ratio \code{G/B}
\item \code{RB} red blue ratio \code{R/B}
\item \code{GR} green red ratio \code{G/R}
\item \code{BI} brightness Index \code{sqrt((R^2+G^2+B^2)/3)}
\item \code{BIM} brightness Index 2 \code{sqrt((R*2+G*2+B*2)/3)}
\item \code{SCI} Soil Colour Index \code{(R-G)/(R+G)}
\item \code{GLI} Green leaf index Vis Louhaichi et al. (2001) \code{(2*G-R-B)/(2*G+R+B)}
\item \code{HI} Primary colours Hue Index    (2*R-G-B)/(G-B)
\item \code{NDGRI} Normalized green red difference index (Tucker, 1979) \code{(G-R)/(G+R)}
\item \code{NDGBI} Normalized green blue difference index \code{(G-B)/(G+B)}
\item \code{NDRBI} Normalized red blue difference index \code{(R-B)/(R+B)}
\item \code{I}     R+G+B
\item \code{S}     ((R+G+B)-3*B)/(R+G+B)
\item \code{L}     R+G+B/3
\item \code{VARI} A Visible Atmospherically Resistant Index \code{(G-R)/(G+R-B)}
\item \code{HUE} Overall Hue Index \code{atan(2*(B-G-R)/30.5*(G-R))}
\item \code{HUE2}  atan(2*(R-G-R)/30.5*(G-B))
\item \code{BGI}   B/G
\item \code{GRAY}	\code{0.299*R + 0.587*G + 0.114*B}
\item \code{GLAI} \code{(25*(G-R)/(G+R-B)+1.25)}
\item \code{CI} Coloration Index \code{(R-B)/R}
\item \code{SAT} Overhall Saturation Index \code{(max(R,G,B) - min(R,G,B)) / max(R,G,B)}
\item \code{SHP} Shape Index \code{2*(R-G-B)/(G-B)}
\item \code{RI} Redness Index \code{R**2/(B*G**3)}
}
}
\examples{
library(pliman)
img <- image_pliman("soybean_touch.jpg")
image_index(img, index = c("R, NR"))
library(pliman)
img <- image_pliman("sev_leaf.jpg")

# resize the image to 30\% of the original size
ind <- image_index(img, resize = 30, show_image = FALSE)
plot(ind)
}
\references{
Nobuyuki Otsu, "A threshold selection method from gray-level
histograms". IEEE Trans. Sys., Man., Cyber. 9 (1): 62-66. 1979.
\doi{10.1109/TSMC.1979.4310076}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}

Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
