% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_shp.R
\name{object_export_shp}
\alias{object_export_shp}
\title{Export multiple objects from an image to multiple images}
\usage{
object_export_shp(
  img,
  pattern = NULL,
  dir_original = NULL,
  dir_processed = NULL,
  format = ".jpg",
  subfolder = NULL,
  squarize = FALSE,
  nrow = 1,
  ncol = 1,
  buffer_x = 0,
  buffer_y = 0,
  interactive = FALSE,
  parallel = FALSE,
  verbose = TRUE,
  viewer = get_pliman_viewer()
)
}
\arguments{
\item{img}{An object of class \code{Image}}

\item{pattern}{A pattern of file name used to identify images to be
processed. For example, if \code{pattern = "im"} all images in the current
working directory that the name matches the pattern (e.g., img1.-,
image1.-, im2.-) will be imported and processed. Providing any number as
pattern (e.g., \code{pattern = "1"}) will select images that are named as 1.-,
2.-, and so on. An error will be returned if the pattern matches any file
that is not supported (e.g., img1.pdf).}

\item{dir_original}{The directory containing the original images. Defaults to
\code{NULL}. It can be either a full path, e.g., \code{"C:/Desktop/imgs"}, or a
subfolder within the current working directory, e.g., \code{"/imgs"}.}

\item{dir_processed}{Optional character string indicating a subfolder within the
current working directory to save the image(s). If the folder doesn't
exist, it will be created.}

\item{format}{The format of image to be exported.}

\item{subfolder}{Optional character string indicating a subfolder within the
current working directory to save the image(s). If the folder doesn't
exist, it will be created.}

\item{squarize}{Squarizes the image before the exportation? If \code{TRUE},
\code{\link[=image_square]{image_square()}} will be called internally.}

\item{nrow}{The number of desired rows in the grid. Defaults to \code{1}.}

\item{ncol}{The number of desired columns in the grid. Defaults to \code{1}.}

\item{buffer_x, buffer_y}{Buffering factor for the width and height,
respectively, of each individual shape's side. A value between 0 and 0.5 where 0
means no buffering and 0.5 means complete buffering (default: 0). A value of
0.25 will buffer the shape by 25\% on each side.}

\item{interactive}{If \code{FALSE} (default) the grid is created automatically
based on the image dimension and number of rows/columns. If \code{interactive = TRUE}, users must draw points at the diagonal of the desired bounding box
that will contain the grid.}

\item{parallel}{If \code{TRUE} processes the images asynchronously (in parallel) in
separate R sessions running in the background on the same machine. It may
speed up the processing time, especially when \code{pattern} is used is informed.
When \code{object_index} is informed, multiple sections will be used to extract
the RGB values for each object in the image. This may significantly speed up
processing time when an image has lots of objects (say >1000).}

\item{verbose}{If \code{TRUE} (default) a summary is shown in the console.}

\item{viewer}{The viewer option. If not provided, the value is retrieved
using \code{\link[=get_pliman_viewer]{get_pliman_viewer()}}. This option controls the type of viewer to use
for interactive plotting. The available options are \code{"base"} and
\code{"mapview"}. If set to "base", the base R graphics system is used for
interactive plotting. If set to "mapview", the mapview package is used. To
set this argument globally for all functions in the package, you can use
the \code{\link[=set_pliman_viewer]{set_pliman_viewer()}} function. For example, you can run
\code{set_pliman_viewer("mapview")} to set the viewer option to "mapview" for
all functions.}
}
\value{
A \code{NULL} object.
}
\description{
Givin an image with multiple objects, \code{object_export_shp()} will split the
objects into a list of objects using \code{\link[=object_split_shp]{object_split_shp()}} and then export
them to multiple images into the current working directory (or a subfolder).
Batch processing is performed by declaring a file name pattern that matches
the images within the working directory.
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(pliman)
flax <- image_pliman("flax_leaves.jpg", plot = TRUE)
object_export_shp(flax)

}
}
