% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{ccc}
\alias{ccc}
\title{Lin's Concordance Correlation Coefficient (CCC)}
\usage{
ccc(data, real, predito)
}
\arguments{
\item{data}{A data frame containing the columns for observed and predicted values.}

\item{real}{The column name (unquoted) corresponding to the observed values.}

\item{predito}{The column name (unquoted) corresponding to the predicted values.}
}
\value{
A data frame with the following columns:
\itemize{
\item \code{r}: Pearson correlation coefficient
\item \code{ccc}: Lin's Concordance Correlation Coefficient
\item \code{rmse}: Root mean squared error
}
}
\description{
Computes Lin's Concordance Correlation Coefficient (CCC) between observed and
predicted values. Also returns Pearson's correlation coefficient and root
mean squared error (RMSE). If the input is a grouped data frame
(\code{grouped_df}), the function will return results for each group.
}
\details{
The CCC is defined as:

\deqn{\rho_c = \frac{2 \cdot \text{Cov}(x, y)}{\text{Var}(x) + \text{Var}(y) + (\bar{x} - \bar{y})^2}}

where:
\itemize{
\item \eqn{\text{Cov}(x, y)} is the covariance between observed and predicted values
\item \eqn{\text{Var}(x)} and \eqn{\text{Var}(y)} are the variances of the observed and predicted values
\item \eqn{\bar{x}} and \eqn{\bar{y}} are the means of the observed and predicted values
}
}
\examples{
library(dplyr)
library(pliman)
df <- data.frame(
  group = rep(c("A", "B"), each = 5),
  real = c(1:5, 2:6),
  predicted = c(1.1, 2, 2.9, 4.1, 5, 2.2, 3.1, 4, 4.8, 6.1)
)

# Without grouping
ccc(df, real, predicted)

# With grouping
df |>
  group_by(group) |>
  ccc(real, predicted)

}
