% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/individualQC.R
\name{run_check_missingness}
\alias{run_check_missingness}
\title{Run PLINK missingness rate calculation}
\usage{
run_check_missingness(indir, name, qcdir = indir, verbose = FALSE,
  path2plink = NULL, showPlinkOutput = TRUE)
}
\arguments{
\item{indir}{[character] /path/to/directory containing the basic PLINK data
files name.bim, name.bed, name.fam files.}

\item{name}{[character] Prefix of PLINK files, i.e. name.bed, name.bim,
name.fam.}

\item{qcdir}{[character] /path/to/directory to save name.imiss as returned
by plink --missing. User needs writing permission to qcdir. Per default
qcdir=indir.}

\item{verbose}{[logical] If TRUE, progress info is printed to standard out.}

\item{path2plink}{[character] Absolute path to directory where external plink
software \url{https://www.cog-genomics.org/plink/1.9/} can be found, i.e.
plink should be accesible as path2plink/plink -h. If not
provided, assumed that PATH set-up works and plink will be found by
system("plink").}

\item{showPlinkOutput}{[logical] If TRUE, plink log and error messages are
printed to standard out.}
}
\description{
Run  plink --missing to calculate missing genotype rates
per individual.
}
\details{
All, \code{\link{run_check_heterozygosity}},
\code{\link{run_check_missingness}} and their evaluation by
\code{\link{evaluate_check_het_and_miss}} can simply be invoked by
\code{\link{check_het_and_miss}}.
}
\examples{
package.dir <- find.package('plinkQC')
indir <- file.path(package.dir,'extdata')
name <- 'data'
qcdir <- tempdir()
# the following code is not run on package build, as the path2plink on the
# user system is not known.
\dontrun{
run <- run_check_missingnessness(indir=indir, qcdir=qcdir, name=name)
}
}
