% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/name_and_count_bigsnp.R
\name{name_and_count_bigsnp}
\alias{name_and_count_bigsnp}
\title{A helper function to label and summarize the contents of a \code{bigSNP}}
\usage{
name_and_count_bigsnp(obj, id_var, quiet, outfile)
}
\arguments{
\item{obj}{a \code{bigSNP} object, possibly subset by \code{add_external_phenotype()}}

\item{id_var}{String specifying which column of the PLINK \code{.fam} file has the unique sample identifiers. Options are "IID" (default) and "FID".}

\item{quiet}{Logical: should messages be printed to the console? Defaults to TRUE}

\item{outfile}{The string with the name of the .log file}
}
\value{
a list with components:
\itemize{
\item counts: column-wise summary of the minor allele counts in 'genotypes'
\item obj: a modified \code{bigSNP} list with additional components
\item X: the \code{obj$genotypes} as its own FBM
\item pos: the \code{obj$map$physical.pos} vector
}
}
\description{
A helper function to label and summarize the contents of a \code{bigSNP}
}
\keyword{internal}
