% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conf_region.R
\name{add_confregions}
\alias{add_confregions}
\title{Compute the confidence regions of covariate effects}
\usage{
add_confregions(x, conf = 0.95, npoints = 100)
}
\arguments{
\item{x}{an object of class \code{field3logit} or \code{multifield3logit}.}

\item{conf}{confidence level of the regions.}

\item{npoints}{number of points of the borders of the regions.}
}
\value{
Object of class \code{field3logit} or \code{multifield3logit} with updated
confidence regions.
}
\description{
Given the confidence level, it computes the confidence regions of the effects
for each arrow of the \code{field3logit} or \code{multifield3logit} object given in
input. If the \code{field3logit} or \code{multifield3logit} object already contains the
confidence regions, they will be updated if the value of \code{conf} is different.
}
\examples{
data(cross_1year)

mod0 <- nnet::multinom(employment_sit ~ gender + finalgrade,
  data = cross_1year)
field0 <- field3logit(mod0, 'genderFemale')
field0
add_confregions(field0)

}
