% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDK.R
\name{plotDK}
\alias{plotDK}
\title{Generate choropleth maps of Danish Municipalities, Regions, Provinces and Zip-areas}
\usage{
plotDK(
  data = NULL,
  id = NULL,
  value = NULL,
  plotlevel = "municipality",
  show_missing = FALSE,
  show_borders = TRUE,
  interactive = FALSE,
  titel = NULL
)
}
\arguments{
\item{data}{A \code{data.frame} containing an ID-variable specifying either a municipality, region, province or zipcode (see \code{id}), as well as a value-variable
containing any value to be plotted on the chosen level.}

\item{id}{A \code{character} specifying the name of a column in data containing the ID on the chosen level.

For municipalities these variables can be either;
\itemize{
\item A character-variable with danish municipality names. For accepted values see \link[plotDK]{municipality_info}.
\item A numeric/integer-variable with official municipality numbers. For accepted values see \link[plotDK]{municipality_info}.
}

For regions these variables can either;
\itemize{
\item A character-variable with danish region names. For accepted values see \link[plotDK]{region_info}.
\item A numeric/integer-variable with danish region numbers. For accepted values see \link[plotDK]{region_info}.
}

For provinces these variables can be either;
\itemize{
\item A character-variable with danish province names. For accepted values see \link[plotDK]{province_info}.
\item A numeric/integer-variable with danish province numbers. For accepted values see \link[plotDK]{province_info}.
}

For zip-codes these variables can be;
\itemize{
\item A numeric/integer-variable with danish zip-codes. For accepted values see \link[plotDK]{zipcode_info}.
}}

\item{value}{\code{numeric}-, \code{factor}- or \code{character}-variabel to be plotted on the map. Note that \code{character-variables} will be
naively translated to factors behind the scenes. For full control over levels, pre-convert to a factor.}

\item{plotlevel}{\code{character}, indicating which level to plot. Valid options are "municipality", "region", "province", and "zipcode".}

\item{show_missing}{\code{logical}. Should levels not present in data or with NA-values be printed? This can be used to plot only a subset
of entities.}

\item{show_borders}{\code{logical}. Should geom borders be drawn?}

\item{interactive}{\code{logical}. Should the plot be converted to an interactive plotly plot?}

\item{titel}{\code{character}. Optional plot title.}
}
\value{
A ggplot object.
}
\description{
Draws a map that highligths any value of interest across either danish municipalities, regions, provinces or zip-codes. This is essentially
a ggplot2-wrapper incorporating geoms of danish municipalities, regions, provinces and zipcodes. Therefore the output
is compatible with further ggplot2 elements.
}
\examples{

## Empty plot
plotDK()

province_data <- data.frame(
 province_name = c(
   "nordjylland", 
   "østjylland",
   "vestjylland", 
   "fyn", 
   "sydjylland", 
   "vest-ogsydsjælland",
   "østsjælland", 
   "københavnsomegn",
   "byenkøbenhavn", 
   "bornholm",
   "nordsjælland"
 ),
 value = 1:11, 
 stringsAsFactors = FALSE
)




}
