% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_crop_click.R
\name{image_crop_click}
\alias{image_crop_click}
\title{Cut out a Subregion of an Image by Mouse Click}
\usage{
image_crop_click(x, only_value = FALSE, rectangle = TRUE, trim = FALSE)
}
\arguments{
\item{x}{an image read into R by 
\code{magick::image_read} or an image  
modified by functions in the magick 
package.}

\item{only_value}{the default is FALSE, 
which will return the subregion. If you set it to 
TRUE, the result is only four values with 
the order: left, right, top, bottom.}

\item{rectangle}{whether the cropped 
area is a rectangle (default is TRUE). If 
it is FALSE, the subregion can be irregular.}

\item{trim}{this is only used when 
\code{rectangle} is FALSE. It decides whether 
the irregular subregion is to be trimmed. If it 
is FALSE (default), no trimming will be done. 
If it is a 0 to 100 value, 
\code{magick::image_trim} will be used, whose 
\code{fuzz} argument is equal to \code{trim}. 
If it is TRUE (not 1), trimming will be done 
according to the mouse click you have made.}
}
\description{
This function is a wrapper of 
\code{magick::image_crop}. While the 
latter asks you to set a \code{geometry} 
parameter, this function enables you 
to set the four sides of a subregion only 
by click the mouse. You must click at 
least 2 times (that is, click on 2 different
points to define a rectangle). After clicking, 
please press Esc on your keyboard. You 
can also designate an irregular polygon 
by mouse with at least 3 clicks. If it is 
irregular, you MUST click on positions 
in order (something like that, when you 
draw a polygon in R, you must input 
the positions of points in order).
}
