% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corplot.R
\name{CorPairsPlotAtomic}
\alias{CorPairsPlotAtomic}
\title{Atomic Correlation Pairs Plot}
\usage{
CorPairsPlotAtomic(
  data,
  columns = NULL,
  group_by = NULL,
  group_by_sep = "_",
  group_name = NULL,
  diag_type = NULL,
  diag_args = list(),
  layout = c(".\\\\", "\\\\.", "/.", "./"),
  cor_method = c("pearson", "spearman", "kendall"),
  cor_palette = "RdBu",
  cor_palcolor = NULL,
  cor_size = 3,
  cor_format = "corr: {round(corr, 2)}",
  cor_fg = "black",
  cor_bg = "white",
  cor_bg_r = 0.1,
  theme = "theme_this",
  theme_args = list(),
  palette = ifelse(is.null(group_by), "Spectral", "Paired"),
  palcolor = NULL,
  title = NULL,
  subtitle = NULL,
  facet_by = NULL,
  legend.position = "right",
  legend.direction = "vertical",
  seed = 8525,
  ...
)
}
\arguments{
\item{data}{A data frame.}

\item{columns}{The column names of the data to be plotted.
If NULL, all columns, except \code{group_by}, will be used.}

\item{group_by}{The column name of the data to be used for grouping.
Different groups will be plotted in different colors.}

\item{group_by_sep}{The separator used to concatenate multiple columns in \code{group_by}.}

\item{group_name}{The name of the group in the legend.}

\item{diag_type}{The type of the diagonal plots.
Available types: "density", "violin", "histogram", "box", "none".}

\item{diag_args}{A list of additional arguments to be passed to the diagonal plots.}

\item{layout}{The layout of the plots.
Available layouts: ".\\", "\\.", "/.", "./".
\itemize{
\item '\\' or '/' means the diagonal plots are on the top-left to bottom-right diagonal.
\item '.' means where the scatter plots are.
}}

\item{cor_method}{The method to calculate the correlation.
Available methods: "pearson", "spearman", "kendall".
The correlation will be shown in the other triangle of the scatter plots.}

\item{cor_palette}{The color palette for the correlation tile plots.}

\item{cor_palcolor}{Custom colors used to create a color palette for the correlation tile plots.}

\item{cor_size}{The size of the correlation text.}

\item{cor_format}{The format of the correlation text. Default is "corr: \%.2f".
It will be formatted using \code{sprintf(cor_format, corr)}.}

\item{cor_fg}{The color of the correlation text.}

\item{cor_bg}{The background color of the correlation text.}

\item{cor_bg_r}{The radius of the background of the correlation text.}

\item{theme}{A character string or a theme class (i.e. ggplot2::theme_classic) specifying the theme to use.
Default is "theme_this".}

\item{theme_args}{A list of arguments to pass to the theme function.}

\item{palette}{The color palette for the scatter plots and default palette for the diagonal plots.}

\item{palcolor}{Custom colors used to create a color palette for the scatter plots and diagonal plots.}

\item{title}{A character string specifying the title of the plot.
A function can be used to generate the title based on the default title.
This is useful when split_by is used and the title needs to be dynamic.}

\item{subtitle}{A character string specifying the subtitle of the plot.}

\item{facet_by}{A character string specifying the column name of the data frame to facet the plot.
Otherwise, the data will be split by \code{split_by} and generate multiple plots
and combine them into one using \code{patchwork::wrap_plots}}

\item{legend.position}{A character string specifying the position of the legend.
if \code{waiver()}, for single groups, the legend will be "none", otherwise "right".}

\item{legend.direction}{A character string specifying the direction of the legend.}

\item{seed}{The random seed to use. Default is 8525.}

\item{...}{Additional arguments to pass to \code{\link{CorPlot}}.}
}
\value{
A \code{patch_work::wrap_plots} object.
}
\description{
Generate a grid of scatter correlation plots for all pairs of variables.
}
\details{
\code{theme} and \code{theme_args} are also supported, they will be passed to each individual plot.
}
\keyword{internal}
