% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.plsRcoxmodel.R
\name{predict.plsRcoxmodel}
\alias{predict.plsRcoxmodel}
\title{Print method for plsRcox models}
\usage{
\method{predict}{plsRcoxmodel}(
  object,
  newdata,
  comps = object$computed_nt,
  type = c("lp", "risk", "expected", "terms", "scores"),
  se.fit = FALSE,
  weights,
  methodNA = "adaptative",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{An object of the class \code{"plsRcoxmodel"}.}

\item{newdata}{An optional data frame in which to look for variables with
which to predict. If omitted, the fitted values are used.}

\item{comps}{A value with a single value of component to use for prediction.}

\item{type}{Type of predicted value. Choices are the linear predictor
("\code{lp}"), the risk score exp(lp) ("\code{risk}"), the expected number
of events given the covariates and follow-up time ("\code{expected}"), the
terms of the linear predictor ("\code{terms}") or the scores
("\code{scores}").}

\item{se.fit}{If TRUE, pointwise standard errors are produced for the
predictions using the Cox model.}

\item{weights}{Vector of case weights. If \code{weights} is a vector of
integers, then the estimated coefficients are equivalent to estimating the
model from data with the individual \code{cases} replicated as many times as
indicated by \code{weights}.}

\item{methodNA}{Selects the way of predicting the response or the scores of
the new data. For complete rows, without any missing value, there are two
different ways of computing the prediction. As a consequence, for mixed
datasets, with complete and incomplete rows, there are two ways of computing
prediction : either predicts any row as if there were missing values in it
(\code{missingdata}) or selects the prediction method accordingly to the
completeness of the row (\code{adaptative}).}

\item{verbose}{Should some details be displayed ?}

\item{\dots}{Arguments to be passed on to \code{survival::coxph} and to
\code{plsRglm::PLS_lm}.}
}
\value{
When type is "\code{response}", a matrix of predicted response
values is returned.\cr When type is "\code{scores}", a score matrix is
returned.
}
\description{
This function provides a predict method for the class \code{"plsRcoxmodel"}
}
\examples{

data(micro.censure)
data(Xmicro.censure_compl_imp)

X_train_micro <- apply((as.matrix(Xmicro.censure_compl_imp)),FUN="as.numeric",MARGIN=2)[1:80,]
Y_train_micro <- micro.censure$survyear[1:80]
C_train_micro <- micro.censure$DC[1:80]

modpls <- plsRcox(X_train_micro,time=Y_train_micro,event=C_train_micro,nt=3)

predict(modpls)    
#Identical to predict(modpls,type="lp")    

predict(modpls,type="risk")    
predict(modpls,type="expected")    
predict(modpls,type="terms")    
predict(modpls,type="scores")    

predict(modpls,se.fit=TRUE)    
#Identical to predict(modpls,type="lp")    
predict(modpls,type="risk",se.fit=TRUE)    
predict(modpls,type="expected",se.fit=TRUE)    
predict(modpls,type="terms",se.fit=TRUE)    
predict(modpls,type="scores",se.fit=TRUE)    


#Identical to predict(modpls,type="lp")    
predict(modpls,newdata=X_train_micro[1:5,],type="risk")    
#predict(modpls,newdata=X_train_micro[1:5,],type="expected")    
predict(modpls,newdata=X_train_micro[1:5,],type="terms")    
predict(modpls,newdata=X_train_micro[1:5,],type="scores")    

#Identical to predict(modpls,type="lp")    
predict(modpls,newdata=X_train_micro[1:5,],type="risk",se.fit=TRUE)    
#predict(modpls,newdata=X_train_micro[1:5,],type="expected",se.fit=TRUE)    
predict(modpls,newdata=X_train_micro[1:5,],type="terms",se.fit=TRUE)    
predict(modpls,newdata=X_train_micro[1:5,],type="scores")    

predict(modpls,newdata=X_train_micro[1:5,],type="risk",comps=1)    
predict(modpls,newdata=X_train_micro[1:5,],type="risk",comps=2)    
predict(modpls,newdata=X_train_micro[1:5,],type="risk",comps=3)    
try(predict(modpls,newdata=X_train_micro[1:5,],type="risk",comps=4))

predict(modpls,newdata=X_train_micro[1:5,],type="terms",comps=1)    
predict(modpls,newdata=X_train_micro[1:5,],type="terms",comps=2)    
predict(modpls,newdata=X_train_micro[1:5,],type="terms",comps=3)    
try(predict(modpls,newdata=X_train_micro[1:5,],type="terms",comps=4))

predict(modpls,newdata=X_train_micro[1:5,],type="scores",comps=1)    
predict(modpls,newdata=X_train_micro[1:5,],type="scores",comps=2)    
predict(modpls,newdata=X_train_micro[1:5,],type="scores",comps=3)    
try(predict(modpls,newdata=X_train_micro[1:5,],type="scores",comps=4))

}
\references{
plsRcox, Cox-Models in a high dimensional setting in R, Frederic
Bertrand, Philippe Bastien, Nicolas Meyer and Myriam Maumy-Bertrand (2014).
Proceedings of User2014!, Los Angeles, page 152.\cr

Deviance residuals-based sparse PLS and sparse kernel PLS regression for
censored data, Philippe Bastien, Frederic Bertrand, Nicolas Meyer and Myriam
Maumy-Bertrand (2015), Bioinformatics, 31(3):397-404,
doi:10.1093/bioinformatics/btu660.
}
\seealso{
\code{\link[survival]{predict.coxph}}
}
\author{
Frédéric Bertrand\cr
\email{frederic.bertrand@utt.fr}\cr
\url{http://www-irma.u-strasbg.fr/~fbertran/}
}
\keyword{methods}
\keyword{predict}
