% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability.selection.R
\name{stability.selection.heatmap}
\alias{stability.selection.heatmap}
\title{Heatmap visualization of estimated probabilities of selection for each
covariate}
\usage{
stability.selection.heatmap(stab.out, ...)
}
\arguments{
\item{stab.out}{the output of the functions \code{\link{spls.stab}},
\code{\link{logit.spls.stab}} or \code{\link{multinom.spls.stab}}.}

\item{...}{any argument that could be pass to the functions 
\code{\link[fields]{image.plot}} or \code{\link[graphics]{image}}.}
}
\value{
No return, just plot the heatmap in the current graphic window.
}
\description{
The function \code{stability.selection.heatmap} allows to visualize 
estimated probabilities to be selected for each covariate depending on the
value of hyper-parameters in the spls, logit-spls or multinomial-spls models. 
These estimated probabilities are used in the stability selection procedure 
described in Durif et al. (2017).
}
\details{
The procedure is described in Durif et al. (2017). The stability selection 
procedure can be summarize as follow (c.f. Meinshausen and Buhlmann, 2010).

(i) For each candidate values of hyper-parameters, a model is trained 
on \code{nresamp} resamplings of the data. Then, for each candidate value of
the hyper-parameters, the probability that a covariate 
(i.e. a column in \code{X}) is selected is computed among the resamplings.

The estimated probabilities can be visualized as a heatmap with the 
function \code{\link{stability.selection.heatmap}}.

(ii) Eventually, the set of "stable selected" variables corresponds to the 
set of covariates that were selected by most of the training among the 
grid of hyper-parameters candidate values, based on a threshold probability
\code{piThreshold} and a restriction of the grid of hyper-parameters based 
on \code{rhoError} (c.f. Durif et al., 2017, for details).

This function allows to visualize probabalities estimated at the first 
step (i) of the stability selection by the functions \code{\link{spls.stab}},
\code{\link{logit.spls.stab}} or \code{\link{multinom.spls.stab}}.

This function use the function \code{\link{matrix.heatmap}}.
}
\examples{
\dontrun{
### load plsgenomics library
library(plsgenomics)

### generating data
n <- 100
p <- 100
sample1 <- sample.cont(n=n, p=p, kstar=10, lstar=2, 
                       beta.min=0.25, beta.max=0.75, mean.H=0.2, 
                       sigma.H=10, sigma.F=5, sigma.E=5)
                       
X <- sample1$X
Y <- sample1$Y

### hyper-parameters values to test
lambda.l1.range <- seq(0.05,0.95,by=0.1) # between 0 and 1
ncomp.range <- 1:10

### tuning the hyper-parameters
stab1 <- spls.stab(X=X, Y=Y, lambda.l1.range=lambda.l1.range, 
                   ncomp.range=ncomp.range, weight.mat=NULL, 
                   adapt=FALSE, center.X=TRUE, center.Y=TRUE, 
                   scale.X=TRUE, scale.Y=TRUE, weighted.center=FALSE, 
                   ncores=1, nresamp=100)
                       
str(stab1)

### heatmap of estimated probabilities
stability.selection.heatmap(stab1)
}

}
\seealso{
\code{\link{logit.spls}}, \code{\link{stability.selection}}, 
\code{\link{stability.selection.heatmap}}
}
\author{
Ghislain Durif (\url{http://thoth.inrialpes.fr/people/gdurif/}).
}
