% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper.R
\name{pls_fit}
\alias{pls_fit}
\title{Wrapper for mixOmics pls functions}
\usage{
pls_fit(x, y, ncomp = NULL, predictor_prop = 1, ...)
}
\arguments{
\item{x}{A data frame or matrix of predictors.}

\item{y}{For classification, a factor. For regression, a matrix, vector, or
data frame.}

\item{ncomp}{The number of PLS components. If left NULL, the maximum possible
is used.}

\item{predictor_prop}{The maximum proportion of original predictors that can
have \emph{non-zero} coefficients for each PLS component (via regularization).
This value is used for all PLS components for X.}
}
\value{
A model object generated by \code{\link[mixOmics:pls]{mixOmics::pls()}}, \code{\link[mixOmics:plsda]{mixOmics::plsda()}},
\code{\link[mixOmics:spls]{mixOmics::spls()}}, or \code{\link[mixOmics:splsda]{mixOmics::splsda()}}.
}
\description{
Based on arguments, this wrapper routes the data and arguments to the four
\code{pls} functions that are sparse/dense or regression/classification.
}
\keyword{internal}
