% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/digital-ocean.R
\name{do_configure_https}
\alias{do_configure_https}
\title{Add HTTPS to a plumber Droplet}
\usage{
do_configure_https(droplet, domain, email, termsOfService = FALSE,
  force = FALSE)
}
\arguments{
\item{droplet}{The droplet on which to act. See \code{\link[analogsea:droplet]{analogsea::droplet()}}.}

\item{domain}{The domain name associated with this instance. Used to obtain a
TLS/SSL certificate.}

\item{email}{Your email address; given only to letsencrypt when requesting a
certificate to enable them to contact you about issues with renewal or
security.}

\item{termsOfService}{Set to \code{TRUE} to agree to the letsencrypt subscriber
agreement. At the time of writing, the current version is available \href{https://letsencrypt.org/documents/LE-SA-v1.1.1-August-1-2016.pdf}{here}.
Must be set to true to obtain a certificate through letsencrypt.}

\item{force}{If \code{FALSE}, will abort if it believes that the given domain name
is not yet pointing at the appropriate IP address for this droplet. If
\code{TRUE}, will ignore this check and attempt to proceed regardless.}
}
\description{
Adds TLS/SSL (HTTPS) to a droplet created using \code{\link[=do_provision]{do_provision()}}.
}
\details{
In order to get a TLS/SSL certificate, you need to point a domain name to the
IP address associated with your droplet. If you don't already have a domain
name, you can register one \href{http://tres.tl/domain}{here}. Point a (sub)domain
to the IP address associated with your plumber droplet before calling this
function. These changes may take a few minutes or hours to propogate around
the Internet, but once complete you can then execute this function with the
given domain to be granted a TLS/SSL certificate for that domain.

Obtains a free TLS/SSL certificate from
\href{https://letsencrypt.org/}{letsencrypt} and installs it in nginx. It also
configures nginx to route all unencrypted HTTP traffic (port 80) to HTTPS.
Your TLS certificate will be automatically renewed and deployed. It also
opens port 443 in the firewall to allow incoming HTTPS traffic.

Historically, HTTPS certificates required payment in advance. If you
appreciate this service, consider \href{https://letsencrypt.org/donate/}{donating to the letsencryptproject}.
}
