% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plumber-options.R
\name{options_plumber}
\alias{options_plumber}
\title{Plumber options}
\usage{
options_plumber(
  port = getOption("plumber.port"),
  docs = getOption("plumber.docs"),
  docs.callback = getOption("plumber.docs.callback"),
  apiURL = getOption("plumber.apiURL"),
  apiScheme = getOption("plumber.apiScheme"),
  apiHost = getOption("plumber.apiHost"),
  apiPort = getOption("plumber.apiPort"),
  apiPath = getOption("plumber.apiPath"),
  maxRequestSize = getOption("plumber.maxRequestSize"),
  sharedSecret = getOption("plumber.sharedSecret")
)
}
\arguments{
\item{port, docs, docs.callback, apiScheme, apiHost, apiPort, apiPath, apiURL, maxRequestSize, sharedSecret}{See details}
}
\value{
The complete, prior set of \code{\link[=options]{options()}} values.
If a particular parameter is not supplied, it will return the current value.
If no parameters are supplied, all returned values will be the current \code{\link[=options]{options()}} values.
}
\description{
There are a number of global options that affect Plumber's behavior. These can
be set globally with \code{\link[=options]{options()}} or with \code{\link[=options_plumber]{options_plumber()}}. Options set using
\code{\link[=options_plumber]{options_plumber()}} should not include the \code{plumber.} prefix.
}
\details{
\describe{
\item{\code{plumber.port}}{Port Plumber will attempt to use to start http server.
If the port is already in use, server will not be able to start. Defaults to \code{NULL}}
\item{\code{plumber.docs}}{Name of the visual documentation interface to use. Defaults to \code{TRUE}, which will use \code{"swagger"}}
\item{\code{plumber.docs.callback}}{A function. Called with
a single parameter corresponding to the visual documentation url after Plumber server is ready. This can be used
by RStudio to open the docs when then API is ran from the editor. Defaults to option \code{NULL}}
\item{\code{plumber.apiURL}}{Server urls for OpenAPI Specification respecting
pattern \verb{scheme://host:port/path}. Other \verb{api*} options will be ignored when set.}
\item{\code{plumber.apiScheme}}{Scheme used to build OpenAPI url and server url for
OpenAPI Specification. Defaults to \code{http}, or an empty string
when used outside a running router}
\item{\code{plumber.apiHost}}{Host used to build docs url and server url for
OpenAPI Specification. Defaults to \code{host} defined by \code{run} method, or an empty string
when used outside a running router}
\item{\code{plumber.apiPort}}{Port used to build OpenAPI url and server url for
OpenAPI Specification. Defaults to \code{port} defined by \code{run} method, or an empty string
when used outside a running router}
\item{\code{plumber.apiPath}}{Path used to build OpenAPI url and server url for
OpenAPI Specification. Defaults to an empty string}
\item{\code{plumber.maxRequestSize}}{Maximum length in bytes of request body. Body larger
than maximum are rejected with http error 413. \code{0} means unlimited size. Defaults to \code{0}}
\item{\code{plumber.sharedSecret}}{Shared secret used to filter incoming request.
When \code{NULL}, secret is not validated. Otherwise, Plumber compares secret with http header
\code{PLUMBER_SHARED_SECRET}. Failure to match results in http error 400. Defaults to \code{NULL}}
}
}
