% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/d_ply.r
\name{d_ply}
\alias{d_ply}
\title{Split data frame, apply function, and discard results.}
\usage{
d_ply(.data, .variables, .fun = NULL, ..., .progress = "none",
  .inform = FALSE, .drop = TRUE, .print = FALSE, .parallel = FALSE,
  .paropts = NULL)
}
\arguments{
\item{.data}{data frame to be processed}

\item{.variables}{variables to split data frame by, as \code{\link{as.quoted}}
variables, a formula or character vector}

\item{.fun}{function to apply to each piece}

\item{...}{other arguments passed on to \code{.fun}}

\item{.progress}{name of the progress bar to use, see
\code{\link{create_progress_bar}}}

\item{.inform}{produce informative error messages?  This is turned off
by default because it substantially slows processing speed, but is very
useful for debugging}

\item{.drop}{should combinations of variables that do not appear in the
input data be preserved (FALSE) or dropped (TRUE, default)}

\item{.print}{automatically print each result? (default: \code{FALSE})}

\item{.parallel}{if \code{TRUE}, apply function in parallel, using parallel
backend provided by foreach}

\item{.paropts}{a list of additional options passed into
the \code{\link[foreach]{foreach}} function when parallel computation
is enabled.  This is important if (for example) your code relies on
external data or packages: use the \code{.export} and \code{.packages}
arguments to supply them so that all cluster nodes have the correct
environment set up for computing.}
}
\value{
Nothing
}
\description{
For each subset of a data frame, apply function and discard results.
To apply a function for each row, use \code{\link{a_ply}} with
\code{.margins} set to \code{1}.
}
\section{Input}{
 This function splits data frames by variables.
}

\section{Output}{

  All output is discarded. This is useful for functions that you are
  calling purely for their side effects like displaying plots or
  saving output.
}
\references{
Hadley Wickham (2011). The Split-Apply-Combine Strategy
  for Data Analysis. Journal of Statistical Software, 40(1), 1-29.
  \url{http://www.jstatsoft.org/v40/i01/}.
}
\seealso{
Other data frame input: \code{\link{daply}};
  \code{\link{ddply}}; \code{\link{dlply}}

Other no output: \code{\link{a_ply}}; \code{\link{l_ply}};
  \code{\link{m_ply}}
}
\keyword{manip}

