% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trelliPlots.R
\name{trelli_foldchange_boxplot}
\alias{trelli_foldchange_boxplot}
\title{Boxplot trelliscope building function for fold_changes}
\usage{
trelli_foldchange_boxplot(
  trelliData,
  cognostics = "biomolecule count",
  p_value_thresh = 0.05,
  include_points = TRUE,
  ggplot_params = NULL,
  interactive = FALSE,
  path = .getDownloadsFolder(),
  name = "Trelliscope",
  test_mode = FALSE,
  test_example = 1,
  single_plot = FALSE,
  ...
)
}
\arguments{
\item{trelliData}{A trelliscope data object with omicsData and statRes
results. Required.}

\item{cognostics}{A vector of cognostic options for each plot. Valid entries are 
"biomolecule count", "proportion significant", "mean fold change",
and "sd fold change". Default is "biomolecule count".}

\item{p_value_thresh}{A value between 0 and 1 to indicate significant
biomolecules for the anova (MS/NMR) or diffexp_seq (RNA-seq) test. Default is 0.05.}

\item{include_points}{Add points. Default is TRUE.}

\item{ggplot_params}{An optional vector of strings of ggplot parameters to
the backend ggplot function. For example, c("ylab('')", "xlab('')").
Default is NULL.}

\item{interactive}{A logical argument indicating whether the plots should be
interactive or not. Interactive plots are ggplots piped to ggplotly (for
now). Default is FALSE.}

\item{path}{The base directory of the trelliscope application. Default is
Downloads.}

\item{name}{The name of the display. Default is Trelliscope.}

\item{test_mode}{A logical to return a smaller trelliscope to confirm plot
and design. Default is FALSE.}

\item{test_example}{A vector of plot indices to return for test_mode. Default
is 1.}

\item{single_plot}{A TRUE/FALSE to indicate whether 1 plot (not a
trelliscope) should be returned. Default is FALSE.}

\item{...}{Additional arguments to be passed on to the trelli builder}
}
\value{
No return value, builds a trelliscope display of fold_change boxplots that is stored in `path`
}
\description{
Specify a plot design and cognostics for the fold_change boxplot
  trelliscope. Fold change must be grouped by an emeta column, which means
  both an omicsData object and statRes are required to make this plot.
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{ 
if (interactive()) {
library(pmartRdata)

# Transform the data
omicsData <- edata_transform(omicsData = pep_object, data_scale = "log2")

# Group the data by condition
omicsData <- group_designation(omicsData = omicsData, main_effects = c("Phenotype"))

# Apply the IMD ANOVA filter
imdanova_Filt <- imdanova_filter(omicsData = omicsData)
omicsData <- applyFilt(filter_object = imdanova_Filt, omicsData = omicsData,
                       min_nonmiss_anova = 2)

# Normalize my pepData
omicsData <- normalize_global(omicsData, "subset_fn" = "all", "norm_fn" = "median",
                             "apply_norm" = TRUE, "backtransform" = TRUE)

# Implement the IMD ANOVA method and compute all pairwise comparisons 
# (i.e. leave the `comparisons` argument NULL)
statRes <- imd_anova(omicsData = omicsData, test_method = 'combined')

# Generate the trelliData object
trelliData4 <- as.trelliData(omicsData = omicsData, statRes = statRes)

# Build fold_change box plot with statRes data grouped by edata_colname.
trelli_panel_by(trelliData = trelliData4, panel = "RazorProtein") \%>\% 
  trelli_foldchange_boxplot(test_mode = TRUE, 
                            test_example = 1:10,
                            cognostics = c("biomolecule count", 
                                           "proportion significant", 
                                           "mean fold change",
                                           "sd fold change"),
                            path = tempdir()
                           )
                           
                           
#####################
## RNA-SEQ EXAMPLE ##                            
#####################

# Build fold_change box plot with statRes data grouped by edata_colname.
trelli_panel_by(trelliData = trelliData_seq4, panel = "Gene") \%>\% 
  trelli_foldchange_boxplot(test_mode = TRUE, 
                            test_example = c(16823, 16890, 17680, 17976, 17981, 19281),
                            cognostics = c("biomolecule count", 
                                           "proportion significant", 
                                           "mean fold change",
                                           "sd fold change"),
                            path = tempdir()
                           )

\dontshow{closeAllConnections()}
}
}
\dontshow{\}) # examplesIf}
}
\author{
David Degnan, Lisa Bramer
}
