% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_objects.R
\name{imdanova_filter}
\alias{imdanova_filter}
\title{IMD-ANOVA Filter Object}
\usage{
imdanova_filter(omicsData)
}
\arguments{
\item{omicsData}{object of one of the classes "pepData", "isobaricpepData",
"proData", "lipidData", "metabData", or "nmrData", created by
\code{\link{as.pepData}}, \code{\link{as.isobaricpepData}},
\code{\link{as.proData}}, \code{\link{as.lipidData}},
\code{\link{as.metabData}}, or \code{\link{as.nmrData}}, respectively.
Groups (more than one) must have been specified using the
\code{\link{group_designation}} function prior to using the imdanova_filter
function.}
}
\value{
An S3 object of class imdanovaFilt (also a data.frame) containing the
  molecule identifier and number of samples in each group with non-missing
  values for that molecule.
}
\description{
This function returns an imdanovaFilt object for use with
\code{\link{applyFilt}}
}
\details{
The output from this function can be used in conjunction with
  \code{\link{applyFilt}} to filter out molecules that are not present in
  enough samples to do statistical comparisons. If any singleton groups are
  present in the omicsData object, those groups are not part of the filter
  object that is returned.
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pmartRdata)
mypep <- group_designation(omicsData = pep_object, main_effects = "Phenotype")
to_filter <- imdanova_filter(omicsData = mypep)
summary(to_filter, min_nonmiss_anova = 2)
\dontshow{\}) # examplesIf}
}
\author{
Kelly Stratton
}
