% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_designation.R
\name{surv_designation}
\alias{surv_designation}
\title{Create a "surv_DF" attribute so that survival analysis can be implemented.}
\usage{
surv_designation(
  omicsData,
  t_death,
  t_progress = NULL,
  ind_death,
  ind_progress = NULL,
  covariates = NULL
)
}
\arguments{
\item{omicsData}{an object of the class 'lipidData', 'metabData', 'pepData',
or 'proData' usually created by \code{\link{as.lipidData}},
\code{\link{as.metabData}}, \code{\link{as.pepData}}, or
\code{\link{as.proData}}, respectively.}

\item{t_death}{the column in 'f_data' that corresponds to the subjects' time
of death}

\item{t_progress}{the column in 'f_data' that corresponds to the subjects'
time of progression}

\item{ind_death}{the column in 'f_data' that corresponds to the subjects'
status, e.g. alive/dead}

\item{ind_progress}{the column in 'f_data' that corresponds to the subjects'
progression status}

\item{covariates}{the column(s) in 'f_data' that correspond to covariates to
be included in the survivial analysis}
}
\value{
omicsData is returned with the additional attribute
}
\description{
This function will add the necessary information to omicsData such that
survival analysis can be applied to it.
}
\author{
Bryan Stanfill
}
