% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example5.R
\name{example5_sv}
\alias{example5_sv}
\title{Parameter estimation in a simple stochastic volatility model}
\usage{
example5_sv(nIter = 7500)
}
\arguments{
\item{nIter}{The number of iterations in the PMH algorithm. 100 iterations 
takes about a minute on a laptop to execute. 7500 iterations are used 
in the reference below. The length of the burn-in is calculated as one 
fifth of nIter.}
}
\value{
The function returns the estimated marginal parameter posteriors for each 
parameter, the trace of the Markov chain and the resulting autocorrelation 
function. The data is also presented with an estimate of the 
log-volatility.

The function returns a list with the elements:
\itemize{
\item{thhat: The estimate of the mean of the parameter posterior.}
\item{xhat: The estimate of the mean of the log-volatility posterior.}
\item{thhatSD: The estimate of the standard deviation of the parameter 
posterior.}
\item{xhatSD: The estimate of the standard deviation of the log-volatility 
posterior.}
\item{iact: The estimate of the integrated autocorrelation time for each 
parameter.}
\item{estCov: The estimate of the covariance of the parameter posterior.}
}
}
\description{
Minimal working example of parameter estimation in a stochastic volatility 
model using the particle Metropolis-Hastings algorithm with a bootstrap 
particle filter for providing an unbiased estimator of the likelihood. The 
code estimates the parameter posterior for three parameters using 
real-world data.
}
\details{
The Particle Metropolis-Hastings (PMH) algorithm makes use of a Gaussian 
random walk as the proposal for the parameters. The data are scaled 
log-returns from the OMXS30 index during the period from January 2, 2012 
to January 2, 2014.

This version of the code makes use of a proposal that is tuned using a 
pilot run. Furthermore the model is reparameterised to enjoy better mixing 
properties by making the parameters unrestricted to a certain part of the 
real-line.
}
\note{
See Section 6.3.2 in the reference for more details.
}
\examples{
\dontrun{
# Use a short run when testing the code on CRAN
# Set nIter manually if running on local computer
# nIter=1000 is usually enough
if(nchar(Sys.getenv("LONG_TEST")) != 0) {
  nIter=7500
} else {
  nIter=5
}
  
# Run the example script
example5_sv(nIter)
}
}
\author{
Johan Dahlin <johan.dahlin@liu.se>
}
\references{
Dahlin, J. & Schoen, T. B. "Getting started with particle 
Metropolis-Hastings for inference in nonlinear dynamical models." 
pre-print, arXiv:1511.01707, 2015.
}
\keyword{misc}

