% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_citation.R
\name{getCitation}
\alias{getCitation}
\title{Get public-domain citation data}
\usage{
getCitation(
  localDir,
  filename = "open_citation_collection.zip",
  nrows = Inf,
  tableSuffix = NULL,
  overwrite = FALSE,
  con = NULL,
  checkMd5 = TRUE
)
}
\arguments{
\item{localDir}{String indicating path to directory containing the citation
file or to which the citation file should be downloaded.}

\item{filename}{String indicating name of the citation file. This should not
normally be changed from the default.}

\item{nrows}{Number indicating how many rows of the citation file to read.
This should not normally be changed from the default.}

\item{tableSuffix}{String indicating suffix, if any, to append to the table
name.}

\item{overwrite}{Logical indicating whether to overwrite an existing table.}

\item{con}{Connection to the database, created using \code{\link[DBI:dbConnect]{DBI::dbConnect()}}.}

\item{checkMd5}{Logical indicating whether to download the citation file if
the MD5 sums of the local and remote versions do not match. This should not
normally be changed from the default.}
}
\value{
If \code{con} is \code{NULL}, the function returns a data.table with columns
\code{citing_pmid} and \code{cited_pmid}. Beware this is a large table and could
swamp the machine's memory. If \code{con} is not \code{NULL}, the function returns
\code{NULL} invisibly.
}
\description{
Get the latest version of the NIH Open Citation Collection from figshare
\href{https://nih.figshare.com/collections/iCite_Database_Snapshots_NIH_Open_Citation_Collection_/4586573}{here},
and optionally write it to the database. This function requires the shell
command \code{unzip}, available by default on most Unix systems. This function
should not normally be called directly, as it is called by
\code{\link[=modifyPubmedDb]{modifyPubmedDb()}}.
}
\examples{
\dontrun{
dCitation = getCitation('.')
}

}
\seealso{
\code{\link[=parsePmidStatus]{parsePmidStatus()}}, \code{\link[=modifyPubmedDb]{modifyPubmedDb()}}
}
