% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmpp_predInterval.R
\name{pmpp_predinterval}
\alias{pmpp_predinterval}
\title{Random-Window Block Bootstrap for prediction intervals for PMPP model}
\usage{
pmpp_predinterval(model, fframe, boot_reps = 1000, block_size = NULL,
  confidence = 0.95, iter = NULL)
}
\arguments{
\item{model}{PMPP model, as returned by \code{pmpp()}}

\item{fframe}{\code{data.frame} with the same columns as input data
to \code{model}, but with empty rows added to each
cross-sectional unit, as created by \code{create_fframe()}}

\item{boot_reps}{integer; number of bootstrap replications}

\item{block_size}{integer; width of the re-sampled block of residuals}

\item{confidence}{numeric in (0,1); confidence level of the interval}

\item{iter}{iterating constant, to be used in a loop when extraction
from call is needed}
}
\value{
A \code{data.frame} with panel indices, lower and upper bounds and midpoint.
}
\description{
Produces prediction intervals for Posterior Mean Panel Predictor
             model by means of resampling with replacement from model's residuals.
             Block Bootstrap method takes into account heteroskedasticity of the
             error terms, both across units and over time. Block window is chosen randomly.
}
\examples{
\dontrun{data(EmplUK, package = "plm")
EmplUK <- dplyr::filter(EmplUK, year \%in\% c(1978, 1979, 1980, 1981, 1982))
pmpp_model <- pmpp(dep_var = "emp", data = EmplUK)
my_fframe <- create_fframe(EmplUK, 1983:1985)
intervals <- pmpp_predinterval(pmpp_model, my_fframe, boot_reps = 10)
}
}
\references{
Oleszak, M. (2018). "Forecasting sales with micro-panels:
            Empirical Bayes approach. Evidence from consumer goods sector.",
            Erasmus University Thesis Repository
}
\author{
Michal Oleszak
}
