% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_2cmt.R
\name{calc_sd_2cmt}
\alias{calc_sd_2cmt}
\alias{calc_sd_2cmt_linear_bolus}
\alias{calc_sd_2cmt_linear_oral_1_lag}
\alias{calc_sd_2cmt_linear_infusion}
\alias{calc_sd_2cmt_linear_oral_0_lag}
\alias{calc_sd_2cmt_linear_oral_1}
\alias{calc_sd_2cmt_linear_oral_0}
\title{Calculate C(t) for a 1-compartment linear model}
\usage{
calc_sd_2cmt(t, dose, dur = NULL, tinf = NULL, ...)

calc_sd_2cmt_linear_bolus(t, dose, ...)

calc_sd_2cmt_linear_oral_1_lag(t, dose, ...)

calc_sd_2cmt_linear_infusion(t, dose, tinf, ...)

calc_sd_2cmt_linear_oral_0_lag(t, dose, dur, ...)

calc_sd_2cmt_linear_oral_0_lag(t, dose, dur, ...)

calc_sd_2cmt_linear_oral_1(t, dose, ...)

calc_sd_2cmt_linear_oral_0(t, dose, dur, ...)
}
\arguments{
\item{t}{Time after dose (h)}

\item{dose}{Dose}

\item{dur}{Duration of zero-order absorption (h)}

\item{tinf}{Duration of infusion (h)}

\item{...}{Passed to `calc_derived_2cpt()`}
}
\value{
Concentration of drug at requested time (\code{t}) after a single dose, given provided set of parameters and variables.
}
\description{
Calculate C(t) for a 1-compartment linear model
}
\section{Functions}{
\itemize{
\item \code{calc_sd_2cmt_linear_bolus}: Calculate C(t) for a 2-compartment linear model after a single IV bolus dose

\item \code{calc_sd_2cmt_linear_oral_1_lag}: Calculate C(t) for a 2-compartment linear model after a single first-order oral dose with a lag time

\item \code{calc_sd_2cmt_linear_infusion}: Calculate C(t) for a 2-compartment linear model after a single infusion

\item \code{calc_sd_2cmt_linear_oral_0_lag}: Calculate C(t) for a 2-compartment linear model after a single zero-order oral dose, with lag time

\item \code{calc_sd_2cmt_linear_oral_0_lag}: Calculate C(t) for a 2-compartment linear model after a single zero-order oral dose, with lag time

\item \code{calc_sd_2cmt_linear_oral_1}: Calculate C(t) for a 2-compartment linear model after a single first-order oral dose

\item \code{calc_sd_2cmt_linear_oral_0}: Calculate C(t) for a 2-compartment linear model after a single zero-order oral dose
}}

\examples{
Ct <- calc_sd_2cmt_linear_bolus(t = 11.75, CL = 7.5, V1 = 20, V2 = 30, Q = 0.5, dose = 10)
Ct <- calc_sd_2cmt_linear_oral_1_lag(t = 11.75, CL = 7.5, V1 = 20, V2 = 30, Q = 0.5,
    dose = 1000, ka = 1, tlag = 2)
Ctrough <- calc_sd_2cmt_linear_infusion(t = 11.75, CL = 7.5, V1 = 20, V2 = 30, Q = 0.5,
    dose = 10, tinf = 1)
Ctrough <- calc_sd_2cmt_linear_oral_0_lag(t = 11.75, CL = 7.5, V1 = 20, V2 = 30, Q = 0.5,
    dose = 1000, dur = 1, tlag=2)
Ct <- calc_sd_2cmt_linear_oral_0_lag(t = 11.75, CL = 7.5, V1 = 20, V2 = 30, Q = 0.5,
    dose = 1000, dur = 1, tlag=2)
Ct <- calc_sd_2cmt_linear_oral_1(t = 11.75, CL = 7.5, V1 = 20, V2 = 30, Q = 0.5,
    dose = 1000, ka = 1)
Ct <- calc_sd_2cmt_linear_oral_0(t = 11.75, CL = 7.5, V1 = 20, V2 = 30, Q = 0.5,
    dose = 1000, dur = 1)
}
\references{
Bertrand J & Mentre F (2008). Mathematical Expressions of the Pharmacokinetic and Pharmacodynamic Models
implemented in the Monolix software. \url{http://lixoft.com/wp-content/uploads/2016/03/PKPDlibrary.pdf}

Rowland M, Tozer TN. Clinical Pharmacokinetics and Pharmacodynamics: Concepts and Applications (4th). Lippincott Williams & Wilkins, Philadelphia, 2010.
}
\author{
Justin Wilkins, \email{justin.wilkins@occams.com}
}
