% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{formatMat}
\alias{formatMat}
\title{Round a matrix to N signifcant digits in mixed FP/exp notation}
\usage{
formatMat(x, digits = 3, shave.spaces = TRUE)
}
\arguments{
\item{x}{Numeric matrix.}

\item{digits}{Positive integer: the number of digits after the decimal comma to round to
(i.e. one less than the number of significant digits).}

\item{shave.spaces}{Logical: if true, removes spaces to ensure compact output; if false, results
in nearly fixed-width output (almost).}
}
\value{
A numeric matrix with all entries of equal width with the same number of characters
}
\description{
Round a matrix to N signifcant digits in mixed FP/exp notation
}
\examples{
x <- matrix(c(1234567, 12345.67, 123.4567,
              1.23456, -1.23456e-1, 0,
              -1.23456e-4, 1.23456e-2, -1.23456e-6), nrow = 3)
print(formatMat(x), quote = FALSE)
print(formatMat(x, digits = 1), quote = FALSE)
}
