% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/population_env_stoch.R
\name{population_env_stoch}
\alias{population_env_stoch}
\title{Nested functions for population environmental stochasticity.}
\usage{
population_env_stoch(
  populations,
  fecundity_matrix,
  fecundity_max,
  survival_matrix,
  standard_deviation,
  correlation
)
}
\arguments{
\item{populations}{Number of populations.}

\item{fecundity_matrix}{Matrix of transition fecundity rates (Leslie/Lefkovitch matrix with non-zero fecundities only).}

\item{fecundity_max}{Maximum transition fecundity rate (in Leslie/Lefkovitch matrix).}

\item{survival_matrix}{Matrix of transition survival rates (Leslie/Lefkovitch matrix with non-zero survivals only).}

\item{standard_deviation}{Standard deviation matrix for applying environmental stochasticity to transition rates.}

\item{correlation}{List containing either an environmental correlation matrix (correlation_matrix), a pre-calculated transposed (Cholesky) decomposition matrix (t_decomposition_matrix), or a compact transposed (Cholesky) decomposition matrix (t_decomposition_compact_matrix) and a corresponding map of population indices (t_decomposition_compact_map), as per \emph{SpatialCorrelation} class attributes.}
}
\value{
Environmental stochasticity calculation function: \code{function(fecundity_array, survival_array, occupied_indices)}, where:
  \describe{
    \item{\code{fecundity_array}}{3D array of fecundity rates (\emph{stages} rows by \emph{stages} columns by \emph{populations} deep).}
    \item{\code{survival_array}}{3D array of survival rates (\emph{stages} rows by \emph{stages} columns by \emph{populations} deep).}
    \item{\code{occupied_indices}}{Array of indices for those populations occupied.}
    \item{\code{returns}}{List containing stochastically varied fecundity and survival arrays.}
  }
}
\description{
Modular functions for the population simulator for performing correlated
environmentally stochastic adjustments to transition rates.
}
