% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pointer.plot.R
\name{pointer.plot}
\alias{pointer.plot}
\title{Plot pointer years for multiple sites}
\usage{
pointer.plot(list.sites, sign = c("both", "pos", "neg"),
             period = NULL, labels = NULL,
             x.tick.major = 10, x.tick.minor = 5)
}
\arguments{
\item{list.sites}{a \code{list} with \code{lists} as produced by \code{\link{pointer.norm}}, \code{\link{pointer.rgc}}, \code{\link{pointer.zchron}} or \code{\link{interval.trend}} for individual sites (created using list(site1, site2,..)).}

\item{sign}{a \code{character} string specifying whether both positive and negative (\code{"both"}), or only positive (\code{"pos"}) or negative (\code{"neg"}) pointer years should be displayed. Defaults to \code{"both"}.}

\item{period}{a \code{vector} specifying the start and end year to be plotted. Defaults to the full period covered by the output of the pointer year analyses.}

\item{labels}{a \code{character} vector with labels for the sites. Defaults to 'site 1, 2, .., \code{\var{i}}'.}

\item{x.tick.major}{an \code{integer} controlling the major x-axis tick labels. Defaults to 10 years.}

\item{x.tick.minor}{an \code{integer} controlling the minor x-axis ticks. Defaults to 5 years.}
}
\value{
Dot plot.
}
\description{
The function creates a dot plot showing positive and (or) negative pointer years from \code{lists} of the type as produced by \code{\link{pointer.norm}}, \code{\link{pointer.rgc}}, \code{\link{pointer.zchron}} and (or) \code{\link{interval.trend}}.
}
\details{
The function makes a dot plot showing pointer years for multiple sites. Positive and negative pointer years are indicated with different symbols an (or) colors.
}
\examples{
## Plot negative pointer years for multiple sites (or different methods)
data(s033)
detr_s033 <- detrend(s033, method = "Spline", nyrs = 30)
py <- pointer.rgc(s033)
pyn <- pointer.norm(detr_s033, method = "Neuwirth")
it <- interval.trend(s033)
zchron <- pointer.zchron(detr_s033)
comparison <- list(py, pyn, it, zchron)
pointer.plot(comparison, sign = "neg", period = c(1950, 2013),
             labels = c("py", "pyn", "it", "zchron")) 

## Plot pointer years for different specifications of pointer.norm (method "Neuwirth")
data(s033)
w09 <- pointer.norm(detr_s033, window = 9, method.thresh = "Neuwirth")
w11 <- pointer.norm(detr_s033, window = 11, method.thresh = "Neuwirth")
w13 <- pointer.norm(detr_s033, method.thresh = "Neuwirth")
comparison <- list(w09, w11, w13)
pointer.plot(comparison, period = c(1950, 2007)) 
           
}
\author{
Marieke van der Maaten-Theunissen and Ernst van der Maaten.
}
