% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logging.R
\name{log4r_step}
\alias{log4r_step}
\title{Enable logging of failure conditions at the validation step level}
\usage{
log4r_step(x, message = NULL, append_to = "pb_log_file")
}
\arguments{
\item{x}{A reference to the x-list object prepared by the \code{agent}. This
version of the x-list is the same as that generated via
\verb{get_agent_x_list(<agent>, i = <step>)} except this version is internally
generated and hence only available in an internal evaluation context.}

\item{message}{The message to use for the log entry. When not provided, a
default glue string is used for the messaging. This is dynamic since the
internal \code{glue::glue()} call occurs in the same environment as \code{x}, the
x-list that's constrained to the validation step. The default message, used
when \code{message = NULL} is the glue string \code{"Step {x$i} exceeded the {level} failure threshold (f_failed = {x$f_failed}) ['{x$type}']"}. As can be seen,
a custom message can be crafted that uses other elements of the x-list with
the \verb{\{x$<component>\}} construction.}

\item{append_to}{The file to which log entries at the warn level are
appended. This can alternatively be one or more \strong{log4r} appenders.}
}
\value{
Nothing is returned however log files may be written in very specific
conditions.
}
\description{
The \code{log4r_step()} function can be used as an action in the \code{\link[=action_levels]{action_levels()}}
function (as a list component for the \code{fns} list). Place a call to this
function in every failure condition that should produce a log (i.e., \code{warn},
\code{stop}, \code{notify}). Only the failure condition with the highest severity for a
given validation step will produce a log entry (skipping failure conditions
with lower severity) so long as the call to \code{log4r_step()} is present.
}
\section{Function ID}{

5-1
}

\examples{
# We can create an `action_levels`
# object that has a threshold for
# the `warn` state, and, an
# associated function that should
# be invoked whenever the `warn`
# state is entered. Here, the
# function call with `log4r_step()`
# will be invoked whenever there
# is one failing test unit. It's
# important to match things up here;
# notice that `warn_at` is given a
# threshold and the list of functions
# given to `fns` has a `warn` component
al <-
  action_levels(
    warn_at = 1,
    fns = list(
      warn = ~ log4r_step(
        x, append_to = "example_log"
      )
    )
  )

# Printing `al` will show us the
# settings for the
# `action_levels` object:
al

# Let's create an agent with
# `small_table` as the target
# table, apply the `action_levels`
# object created above as `al`,
# add two validation steps, and
# then `interrogate()` the data
agent <- 
  create_agent(
    tbl = ~ small_table,
    tbl_name = "small_table",
    actions = al
  ) \%>\%
  col_vals_gt(vars(d), 300) \%>\%
  col_vals_in_set(
    vars(f), c("low", "high")
  ) \%>\%
  interrogate()

# From the agent report, we can
# see that both steps have yielded
# warnings upon interrogation
# (i.e., filled yellow circles
# in the `W` column).

# We can see this more directly
# by inspecting the `warn`
# component of the agent's x-list:
get_agent_x_list(agent)$warn

# Upon entering the `warn` state
# in each validation step during
# interrogation, the `log4r_step()`
# function call was invoked! This
# will generate an `"example_log"`
# file in the working directory
# and log entries will be appended
# to the file

if (file.exists("example_log")) {
  file.remove("example_log")
}

}
\concept{Logging}
