% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_transformers.R
\name{tt_string_info}
\alias{tt_string_info}
\title{Table Transformer: obtain a summary table for string columns}
\usage{
tt_string_info(tbl)
}
\arguments{
\item{tbl}{A table object to be used as input for the transformation. This
can be a data frame, a tibble, a \code{tbl_dbi} object, or a \code{tbl_spark} object.}
}
\value{
A \code{tibble} object.
}
\description{
With any table object, you can produce a summary table that is scoped to
string-based columns. The output summary table will have a leading column
called \code{".param."} with labels for each of the three rows, each corresponding
to the following pieces of information pertaining to string length:
\enumerate{
\item Mean String Length (\code{"length_mean"})
\item Minimum String Length (\code{"length_min"})
\item Maximum String Length (\code{"length_max"})
}

Only string data from the input table will generate columns in the output
table. Column names from the input will be used in the output, preserving
order as well.
}
\section{Function ID}{

12-2
}

\examples{
# Get string information for the
# string-based columns in the
# `game_revenue` dataset
tt_string_info(game_revenue)

# Ensure that `player_id` and
# `session_id` values always have
# the same number of characters
# throughout the table
tt_string_info(game_revenue) \%>\%
  col_vals_equal(
    columns = vars(player_id),
    value = 15
  ) \%>\%
  col_vals_equal(
    columns = vars(session_id),
    value = 24
  )

# Check that the maximum string
# length in column `f` of the
# `small_table` dataset is no
# greater than `4`
tt_string_info(small_table) \%>\%
  test_col_vals_lte(
    columns = vars(f),
    value = 4
  )

}
\seealso{
Other Table Transformers: 
\code{\link{get_tt_param}()},
\code{\link{tt_summary_stats}()},
\code{\link{tt_tbl_colnames}()},
\code{\link{tt_tbl_dims}()},
\code{\link{tt_time_shift}()},
\code{\link{tt_time_slice}()}
}
\concept{Table Transformers}
