% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/col_exists.R
\name{col_exists}
\alias{col_exists}
\title{Do one or more columns actually exist?}
\usage{
col_exists(x, columns, actions = NULL, brief = NULL, active = TRUE)
}
\arguments{
\item{x}{A data frame, tibble, or an agent object of class \code{ptblank_agent}.}

\item{columns}{One or more columns from the table in focus. This can be
provided as a vector of column names using \code{c()} or bare column names
enclosed in \code{\link[=vars]{vars()}}.}

\item{actions}{A list containing threshold levels so that the validation step
can react accordingly when exceeding the set levels. This is to be created
with the \code{\link[=action_levels]{action_levels()}} helper function.}

\item{brief}{An optional, text-based description for the validation step.}

\item{active}{A logical value indicating whether the validation step should
be active. If the step function is working with an agent, \code{FALSE} will make
the validation step inactive (still reporting its presence and keeping
indexes for the steps unchanged). If the step function will be operating
directly on data, then any step with \code{active = FALSE} will simply pass the
data through with no validation whatsoever. The default for this is \code{TRUE}.}
}
\value{
Either a \code{ptblank_agent} object or a table object, depending on what
was passed to \code{x}.
}
\description{
The \code{col_exists()} validation step function checks whether one or more
columns exist in the target table. The only requirement is a specification of
the column names. Each validation step will operate over a single test unit,
which is whether the column exists or not.
}
\details{
If providing multiple column names, the result will be an expansion of
validation steps to that number of column names (e.g., \code{vars(col_a, col_b)}
will result in the entry of two validation steps). Aside from column names
in quotes and in \code{vars()}, \strong{tidyselect} helper functions are available for
specifying columns. They are: \code{starts_with()}, \code{ends_with()}, \code{contains()},
\code{matches()}, and \code{everything()}.

Often, we will want to specify \code{actions} for the validation. This argument,
present in every validation step function, takes a specially-crafted list
object that is best produced by the \code{\link[=action_levels]{action_levels()}} function. Read that
function's documentation for the lowdown on how to create reactions to
above-threshold failure levels in validation. The basic gist is that you'll
want at least a single threshold level (specified as either the fraction test
units failed, or, an absolute value), often using the \code{warn_at} argument.
Using \code{action_levels(warn_at = 1)} or \code{action_levels(stop_at = 1)} are good
choices depending on the situation (the first produces a warning, the other
\code{stop()}s).

Want to describe this validation step in some detail? Keep in mind that this
is only useful if \code{x} is an \emph{agent}. If that's the case, \code{brief} the agent
with some text that fits. Don't worry if you don't want to do it. The
\emph{autobrief} protocol is kicked in when \code{brief = NULL} and a simple brief will
then be automatically generated.
}
\section{Function ID}{

2-23
}

\examples{
# Create a simple table with
# two columns of numerical values
tbl <-
  dplyr::tibble(
    a = c(5, 7, 6, 5, 8, 7),
    b = c(7, 1, 0, 0, 0, 3)
  )

# Validate that columns `a` and `b`
# exist in the `tbl` table
agent <-
  create_agent(tbl = tbl) \%>\%
  col_exists(vars(a, b)) \%>\%
  interrogate()

# Determine if these three validation
# steps passed by using `all_passed()`
all_passed(agent)

}
\seealso{
Other Validation Step Functions: 
\code{\link{col_is_character}()},
\code{\link{col_is_date}()},
\code{\link{col_is_factor}()},
\code{\link{col_is_integer}()},
\code{\link{col_is_logical}()},
\code{\link{col_is_numeric}()},
\code{\link{col_is_posix}()},
\code{\link{col_schema_match}()},
\code{\link{col_vals_between}()},
\code{\link{col_vals_equal}()},
\code{\link{col_vals_gte}()},
\code{\link{col_vals_gt}()},
\code{\link{col_vals_in_set}()},
\code{\link{col_vals_lte}()},
\code{\link{col_vals_lt}()},
\code{\link{col_vals_not_between}()},
\code{\link{col_vals_not_equal}()},
\code{\link{col_vals_not_in_set}()},
\code{\link{col_vals_not_null}()},
\code{\link{col_vals_null}()},
\code{\link{col_vals_regex}()},
\code{\link{conjointly}()},
\code{\link{rows_distinct}()}
}
\concept{Validation Step Functions}
