% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data_extracts.R
\name{get_data_extracts}
\alias{get_data_extracts}
\title{Collect data extracts from a validation step}
\usage{
get_data_extracts(agent, i = NULL)
}
\arguments{
\item{agent}{An agent object of class \code{ptblank_agent}. It should have had
\code{\link[=interrogate]{interrogate()}} called on it, such that the validation steps were carried
out and any sample rows from non-passing validations could potentially be
available in the object.}

\item{i}{The validation step number, which is assigned to each validation
step in the order of definition. If \code{NULL} (the default), all data extract
tables will be provided in a list object.}
}
\value{
A list of tables if \code{i} is not provided, or, a standalone table if
\code{i} is given.
}
\description{
In an agent-based workflow, after interrogation with \code{\link[=interrogate]{interrogate()}} we can
get the row data that didn't pass row-based validation steps with the
\code{get_data_extracts()} function. The amount of data available in a particular
extract depends on both the fraction of test units that didn't pass a
validation step and the level of sampling or explicit collection from that
set of units.

The availability of data extracts for each row-based validation step is
depends on whether \code{extract_failed} is set to \code{TRUE} within the
\code{\link[=interrogate]{interrogate()}} call (it is by default). The amount of \emph{fail} rows extracted
depends on the collection parameters in \code{\link[=interrogate]{interrogate()}}, and the default
behavior is to collect up to the first 5000 \emph{fail} rows.

Row-based validation steps are based on the validation functions of the form
\verb{col_vals_*()} and also include \code{\link[=conjointly]{conjointly()}} and \code{\link[=rows_distinct]{rows_distinct()}}. Only
those types of validation steps can provide data extracts.
}
\section{Function ID}{

5-3
}

\examples{
# Create a simple table with a
# column of numerical values
tbl <- 
  dplyr::tibble(a = c(5, 7, 8, 5))

# Create 2 simple validation steps
# that test whether values within
# column `a`
agent <-
  create_agent(tbl = tbl) \%>\%
  col_vals_between(vars(a), 4, 6) \%>\%
  col_vals_lte(vars(a), 7) \%>\%
  interrogate(
    extract_failed = TRUE,
    get_first_n = 10
  )

# Get row sample data for those rows
# in `tbl` that did not pass the first
# validation step (`col_vals_between`)
agent \%>\% get_data_extracts(i = 1)

}
\seealso{
Other Post-interrogation: 
\code{\link{all_passed}()},
\code{\link{get_agent_report}()},
\code{\link{get_agent_x_list}()},
\code{\link{get_sundered_data}()}
}
\concept{Post-interrogation}
